/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import picocli.CommandLine;

public abstract class CliCommand
implements Callable<Integer> {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec commandSpec;
    private static final ObjectMapper MAPPER = ObjectMapperFactory.create();
    private static final ObjectWriter WRITER = MAPPER.writerWithDefaultPrettyPrinter();

    static String[] validatePropertyCluster(String params) {
        String[] parts = params.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Parameter format is incorrect");
        }
        return parts;
    }

    static String validateNamespace(String namespace) {
        return NamespaceName.get((String)namespace).toString();
    }

    static String validateTopicName(String topic) {
        return TopicName.get((String)topic).toString();
    }

    static String validatePersistentTopic(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        if (topicName.getDomain() != TopicDomain.persistent) {
            throw new IllegalArgumentException("Need to provide a persistent topic name");
        }
        return topicName.toString();
    }

    static String validateNonPersistentTopic(String topic) {
        TopicName topicName = TopicName.get((String)topic);
        if (topicName.getDomain() != TopicDomain.non_persistent) {
            throw new IllegalArgumentException("Need to provide a non-persistent topic name");
        }
        return topicName.toString();
    }

    static MessageId validateMessageIdString(String resetMessageIdStr) throws PulsarAdminException {
        return CliCommand.validateMessageIdString(resetMessageIdStr, -1);
    }

    static MessageId validateMessageIdString(String resetMessageIdStr, int partitionIndex) throws PulsarAdminException {
        String[] messageId = resetMessageIdStr.split(":");
        try {
            Preconditions.checkArgument((messageId.length == 2 ? 1 : 0) != 0);
            return new MessageIdImpl(Long.parseLong(messageId[0]), Long.parseLong(messageId[1]), partitionIndex);
        }
        catch (Exception e) {
            throw new PulsarAdminException("Invalid message id (must be in format: ledgerId:entryId) value " + resetMessageIdStr);
        }
    }

    Set<AuthAction> getAuthActions(List<String> actions) {
        TreeSet<AuthAction> res = new TreeSet<AuthAction>();
        for (String action : actions) {
            AuthAction authAction;
            try {
                authAction = AuthAction.valueOf((String)action);
            }
            catch (IllegalArgumentException exception) {
                throw new ParameterException(String.format("Illegal auth action '%s'. Possible values: %s", action, Arrays.toString(AuthAction.values())));
            }
            res.add(authAction);
        }
        return res;
    }

    <T> void print(List<T> items) {
        for (T item : items) {
            this.print(item);
        }
    }

    <K, V> void print(Map<K, V> items) {
        for (Map.Entry<K, V> entry : items.entrySet()) {
            this.print(String.valueOf(entry.getKey()) + "    " + String.valueOf(entry.getValue()));
        }
    }

    <T> void print(T item) {
        try {
            if (item instanceof String) {
                this.commandSpec.commandLine().getOut().println(item);
            } else {
                this.prettyPrint(item);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    <T> void prettyPrint(T item) {
        try {
            this.commandSpec.commandLine().getOut().println(WRITER.writeValueAsString(item));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Integer call() throws Exception {
        this.run();
        return 0;
    }

    abstract void run() throws Exception;

    protected class ParameterException
    extends CommandLine.ParameterException {
        public ParameterException(String msg) {
            super(CliCommand.this.commandSpec.commandLine(), msg);
        }

        public ParameterException(String msg, Throwable e) {
            super(CliCommand.this.commandSpec.commandLine(), msg, e);
        }
    }
}

