# PIP-395: Add Proxy configuration to support configurable response headers for http reverse-proxy


# Motivation

Pulsar Proxy has a support to use it as HTTP reverse proxy to access Broker’s admin API and can also be extended to act as a reverse proxy other HTTP endpoints. Sometimes, it is very crucial to add customizable headers into the HTTP response returned by Proxy to enhance the security experience while using Proxy over HTTP.

Response headers in a reverse HTTP proxy are critical for maintaining and enhancing the security of the web applications and services behind the proxy. These headers act as a first line of defense, hardening the web server infrastructure and protecting clients from common web vulnerabilities.

For example, when implementing a reverse HTTP proxy, security headers such as `Referrer-Policy`, `X-Content-Type-Options`, `Strict-Transport-Security`, `X-Content-Type-Options`, etc., are useful to prevent security attacks like clickjacking, MIME-sniffing, data leakage, and more. So, such headers play a crucial role in enhancing the security posture of proxy infrastructure.

Therefore, we would like to add support into Pulsar Proxy where users can add custom response headers by passing them into the configuration. This PIP will add this support by adding a new configuration called `proxyHttpResponseHeadersJson` where user can pass multiple headers with key-value map into the json format. Proxy server will retrieve headers from this configuration and pass it as response headers for every http request when user wants to use Pulsar Proxy as an HTTP reverse proxy.


# Goals

## In Scope

Add a new configuration `proxyHttpResponseHeadersJson` to the Proxy configuration.
eg:
```
proxyHttpResponseHeadersJson=`{"header1":"value1","header2":"value2"}`
```

## Out of Scope

# High Level Design

# Detailed Design

## Design & Implementation Details

Add a new configuration `proxyHttpResponseHeadersJson` to the Proxy configuration.
This configuration will allow the user to set default headers which proxy will return into the response headers for every http request which proxy will receive as a reverse proxy.


### Public API
NA
### Binary protocol

### Configuration

### CLI

### Metrics

NA

# Monitoring

NA

# Security Considerations

NA

# Backward & Forward Compatibility

## Upgrade

This is a new feature, and it does not affect the existing configuration.

## Downgrade / Rollback

Rollback will not impact the existing functionality.

## Pulsar Geo-Replication Upgrade & Downgrade/Rollback Considerations

<!--
Describe what needs to be considered in Pulsar Geo-Replication in the upgrade and possible downgrade/rollback of this feature.
-->

# Alternatives

<!--
If there are alternatives that were already considered by the authors or, after the discussion, by the community, and were rejected, please list them here along with the reason why they were rejected.
-->

# General Notes

# Links