/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.qos;

import org.apache.pulsar.broker.qos.AsyncTokenBucket;
import org.apache.pulsar.broker.qos.MonotonicClock;

class FinalRateAsyncTokenBucket
extends AsyncTokenBucket {
    private static final double DEFAULT_TARGET_FILL_FACTOR_AFTER_THROTTLING = 0.01;
    private final long capacity;
    private final long rate;
    private final long ratePeriodNanos;
    private final long nanosForOneToken;
    private final long targetAmountOfTokensAfterThrottling;

    protected FinalRateAsyncTokenBucket(long capacity, long rate, MonotonicClock clockSource, long addTokensResolutionNanos, long ratePeriodNanos, long initialTokens, long targetAmountOfTokensAfterThrottling) {
        super(clockSource, addTokensResolutionNanos);
        this.capacity = capacity;
        this.rate = rate;
        this.ratePeriodNanos = ratePeriodNanos != -1L ? ratePeriodNanos : ONE_SECOND_NANOS;
        this.nanosForOneToken = ratePeriodNanos / rate;
        this.targetAmountOfTokensAfterThrottling = targetAmountOfTokensAfterThrottling >= 0L ? targetAmountOfTokensAfterThrottling : (long)((double)capacity * 0.01);
        this.tokens = initialTokens;
        this.getTokens();
    }

    @Override
    protected final long getRatePeriodNanos() {
        return this.ratePeriodNanos;
    }

    @Override
    protected final long getTargetAmountOfTokensAfterThrottling() {
        return this.targetAmountOfTokensAfterThrottling;
    }

    @Override
    public final long getCapacity() {
        return this.capacity;
    }

    @Override
    public final long getRate() {
        return this.rate;
    }

    @Override
    protected long getNanosForOneToken() {
        return this.nanosForOneToken;
    }
}

