/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.generic.dynamic;

import com.google.gson.Gson;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.util.generic.dynamic.DynamicKubernetesListObject;
import io.kubernetes.client.util.generic.dynamic.DynamicKubernetesObject;
import java.io.IOException;
import java.lang.reflect.Type;

public class DynamicKubernetesTypeAdaptorFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (this.shouldHandleAsSingleObject(typeToken)) {
            return new GenericObjectCreator(gson);
        }
        if (this.shouldHandleAsListObject(typeToken)) {
            return new GenericListObjectCreator(gson);
        }
        return null;
    }

    private boolean shouldHandleAsSingleObject(TypeToken typeToken) {
        if (TypeToken.get(KubernetesObject.class).equals((Object)typeToken)) {
            return true;
        }
        return TypeToken.get(DynamicKubernetesObject.class).equals((Object)typeToken);
    }

    private boolean shouldHandleAsListObject(TypeToken typeToken) {
        if (TypeToken.get(KubernetesListObject.class).equals((Object)typeToken)) {
            return true;
        }
        return TypeToken.get(DynamicKubernetesListObject.class).equals((Object)typeToken);
    }

    class GenericObjectCreator
    extends TypeAdapter<DynamicKubernetesObject>
    implements InstanceCreator<DynamicKubernetesObject> {
        private final Gson delegate;

        GenericObjectCreator(Gson delegate) {
            this.delegate = delegate;
        }

        public DynamicKubernetesObject createInstance(Type type) {
            return new DynamicKubernetesObject();
        }

        public void write(JsonWriter jsonWriter, DynamicKubernetesObject t) throws IOException {
            jsonWriter.jsonValue(this.delegate.toJson((JsonElement)t.getRaw()));
        }

        public DynamicKubernetesObject read(JsonReader jsonReader) throws IOException {
            return new DynamicKubernetesObject((JsonObject)this.delegate.fromJson(jsonReader, JsonObject.class));
        }
    }

    class GenericListObjectCreator
    extends TypeAdapter<DynamicKubernetesListObject>
    implements InstanceCreator<DynamicKubernetesListObject> {
        private final Gson delegate;

        GenericListObjectCreator(Gson delegate) {
            this.delegate = delegate;
        }

        public DynamicKubernetesListObject createInstance(Type type) {
            return new DynamicKubernetesListObject();
        }

        public void write(JsonWriter jsonWriter, DynamicKubernetesListObject t) throws IOException {
            jsonWriter.jsonValue(this.delegate.toJson((JsonElement)t.getRaw()));
        }

        public DynamicKubernetesListObject read(JsonReader jsonReader) throws IOException {
            return new DynamicKubernetesListObject((JsonObject)this.delegate.fromJson(jsonReader, JsonObject.class));
        }
    }
}

