/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.atomic;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jctools.queues.atomic.MpmcAtomicArrayQueue;
import org.jctools.queues.atomic.MpscAtomicArrayQueue;
import org.jctools.queues.atomic.MpscLinkedAtomicQueue;
import org.jctools.queues.atomic.SpmcAtomicArrayQueue;
import org.jctools.queues.atomic.SpscAtomicArrayQueue;
import org.jctools.queues.atomic.SpscLinkedAtomicQueue;
import org.jctools.queues.spec.ConcurrentQueueSpec;

public class AtomicQueueFactory {
    public static <E> Queue<E> newQueue(ConcurrentQueueSpec qs) {
        if (qs.isBounded()) {
            if (qs.isSpsc()) {
                return new SpscAtomicArrayQueue(qs.capacity);
            }
            if (qs.isMpsc()) {
                return new MpscAtomicArrayQueue(qs.capacity);
            }
            if (qs.isSpmc()) {
                return new SpmcAtomicArrayQueue(qs.capacity);
            }
            return new MpmcAtomicArrayQueue(qs.capacity);
        }
        if (qs.isSpsc()) {
            return new SpscLinkedAtomicQueue();
        }
        if (qs.isMpsc()) {
            return new MpscLinkedAtomicQueue();
        }
        return new ConcurrentLinkedQueue();
    }
}

