/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.WebSocketConnectOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.WebsocketVersion;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonArray;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.impl.JsonUtil;

public class WebSocketConnectOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, WebSocketConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "allowOriginHeader": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAllowOriginHeader((Boolean)member.getValue());
                    break;
                }
                case "registerWriteHandlers": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setRegisterWriteHandlers((Boolean)member.getValue());
                    break;
                }
                case "subProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setSubProtocols(list);
                    break;
                }
                case "version": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setVersion(WebsocketVersion.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(WebSocketConnectOptions obj, JsonObject json) {
        WebSocketConnectOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(WebSocketConnectOptions obj, Map<String, Object> json) {
        json.put("allowOriginHeader", obj.getAllowOriginHeader());
        json.put("registerWriteHandlers", obj.isRegisterWriteHandlers());
        if (obj.getSubProtocols() != null) {
            JsonArray array = new JsonArray();
            obj.getSubProtocols().forEach(item -> array.add(item));
            json.put("subProtocols", array);
        }
        if (obj.getVersion() != null) {
            json.put("version", obj.getVersion().name());
        }
    }
}

