/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.ExceptionalFunction;

public final class ListenableFutures {
    public static <T> CompletableFuture<T> fromListenableFuture(ListenableFuture<T> listenableFuture) {
        return ListenableFutures.fromListenableFuture(listenableFuture, Function.identity());
    }

    public static <T, R> CompletableFuture<R> fromListenableFuture(ListenableFuture<T> listenableFuture, final Function<? super T, ? extends R> mapFn) {
        final CompletableFuture completableFuture = FutureUtils.createFuture();
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                try {
                    Object uResult = mapFn.apply(result);
                    completableFuture.complete(uResult);
                }
                catch (Exception e) {
                    completableFuture.completeExceptionally(e);
                }
            }

            public void onFailure(Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return completableFuture;
    }

    public static <T, R> CompletableFuture<R> fromListenableFuture(ListenableFuture<T> listenableFuture, final ExceptionalFunction<? super T, ? extends R> mapFn) {
        final CompletableFuture completableFuture = FutureUtils.createFuture();
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                try {
                    Object uResult = mapFn.apply(result);
                    completableFuture.complete(uResult);
                }
                catch (Exception e) {
                    completableFuture.completeExceptionally(e);
                }
            }

            public void onFailure(Throwable t) {
                completableFuture.completeExceptionally(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return completableFuture;
    }

    private ListenableFutures() {
    }
}

