/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.util;

import io.oxia.client.util.BatchedBlockingQueue;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;

public class BatchedArrayBlockingQueue<T>
extends AbstractQueue<T>
implements BlockingQueue<T>,
BatchedBlockingQueue<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition notFull = this.lock.newCondition();
    private final int capacity;
    private final T[] data;
    private int size;
    private int consumerIdx;
    private int producerIdx;

    public BatchedArrayBlockingQueue(int capacity) {
        this.capacity = capacity;
        this.data = new Object[this.capacity];
    }

    private T dequeueOne() {
        T item = this.data[this.consumerIdx];
        this.data[this.consumerIdx] = null;
        if (++this.consumerIdx == this.capacity) {
            this.consumerIdx = 0;
        }
        if (this.size-- == this.capacity) {
            this.notFull.signalAll();
        }
        return item;
    }

    private void enqueueOne(T item) {
        this.data[this.producerIdx] = item;
        if (++this.producerIdx == this.capacity) {
            this.producerIdx = 0;
        }
        if (this.size++ == 0) {
            this.notEmpty.signalAll();
        }
    }

    @Override
    public T poll() {
        this.lock.lock();
        try {
            if (this.size == 0) {
                T t = null;
                return t;
            }
            T t = this.dequeueOne();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T peek() {
        this.lock.lock();
        try {
            if (this.size == 0) {
                T t = null;
                return t;
            }
            T t = this.data[this.consumerIdx];
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean offer(@NonNull T e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        this.lock.lock();
        try {
            if (this.size == this.capacity) {
                boolean bl = false;
                return bl;
            }
            this.enqueueOne(e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void put(@NonNull T e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        this.lock.lockInterruptibly();
        try {
            while (this.size == this.capacity) {
                this.notFull.await();
            }
            this.enqueueOne(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int putAll(List<T> c) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.size == this.capacity) {
                this.notFull.await();
            }
            int availableCapacity = this.capacity - this.size;
            int toInsert = Math.min(availableCapacity, c.size());
            int producerIdx = this.producerIdx;
            for (int i = 0; i < toInsert; ++i) {
                this.data[producerIdx] = c.get(i);
                if (++producerIdx != this.capacity) continue;
                producerIdx = 0;
            }
            this.producerIdx = producerIdx;
            if (this.size == 0) {
                this.notEmpty.signalAll();
            }
            this.size += toInsert;
            int n = toInsert;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void putAll(T[] a, int offset, int len) throws InterruptedException {
        while (len > 0) {
            int published = this.internalPutAll(a, offset, len);
            offset += published;
            len -= published;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalPutAll(T[] a, int offset, int len) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.size == this.capacity) {
                this.notFull.await();
            }
            int availableCapacity = this.capacity - this.size;
            int toInsert = Math.min(availableCapacity, len);
            int producerIdx = this.producerIdx;
            int firstSpan = Math.min(toInsert, this.capacity - producerIdx);
            System.arraycopy(a, offset, this.data, producerIdx, firstSpan);
            producerIdx += firstSpan;
            int secondSpan = toInsert - firstSpan;
            if (secondSpan > 0) {
                System.arraycopy(a, offset + firstSpan, this.data, 0, secondSpan);
                producerIdx = secondSpan;
            }
            if (producerIdx == this.capacity) {
                producerIdx = 0;
            }
            this.producerIdx = producerIdx;
            if (this.size == 0) {
                this.notEmpty.signalAll();
            }
            this.size += toInsert;
            int n = toInsert;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        long remainingTimeNanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (this.size == this.capacity) {
                if (remainingTimeNanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                remainingTimeNanos = this.notFull.awaitNanos(remainingTimeNanos);
            }
            this.enqueueOne(e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NonNull
    public T take() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.size == 0) {
                this.notEmpty.await();
            }
            T t = this.dequeueOne();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingTimeNanos = unit.toNanos(timeout);
        this.lock.lockInterruptibly();
        try {
            while (this.size == 0) {
                if (remainingTimeNanos <= 0L) {
                    T t = null;
                    return t;
                }
                remainingTimeNanos = this.notEmpty.awaitNanos(remainingTimeNanos);
            }
            T t = this.dequeueOne();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.size;
    }

    @Override
    public int drainTo(@NonNull Collection<? super T> c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        return this.drainTo(c, this.capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(@NonNull Collection<? super T> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        this.lock.lock();
        try {
            int toDrain = Math.min(this.size, maxElements);
            int consumerIdx = this.consumerIdx;
            for (int i = 0; i < toDrain; ++i) {
                T item = this.data[consumerIdx];
                this.data[consumerIdx] = null;
                c.add(item);
                if (++consumerIdx != this.capacity) continue;
                consumerIdx = 0;
            }
            this.consumerIdx = consumerIdx;
            if (this.size == this.capacity) {
                this.notFull.signalAll();
            }
            this.size -= toDrain;
            int n = toDrain;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int takeAll(T[] array) throws InterruptedException {
        return this.internalTakeAll(array, true, 0L, TimeUnit.SECONDS);
    }

    @Override
    public int pollAll(T[] array, long timeout, TimeUnit unit) throws InterruptedException {
        return this.internalTakeAll(array, false, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int internalTakeAll(T[] array, boolean waitForever, long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (this.size == 0) {
                if (waitForever) {
                    this.notEmpty.await();
                    continue;
                }
                if (this.notEmpty.await(timeout, unit)) continue;
                int n = 0;
                return n;
            }
            int toDrain = Math.min(this.size, array.length);
            int consumerIdx = this.consumerIdx;
            int firstSpan = Math.min(toDrain, this.capacity - consumerIdx);
            System.arraycopy(this.data, consumerIdx, array, 0, firstSpan);
            Arrays.fill(this.data, consumerIdx, consumerIdx + firstSpan, null);
            consumerIdx += firstSpan;
            int secondSpan = toDrain - firstSpan;
            if (secondSpan > 0) {
                System.arraycopy(this.data, 0, array, firstSpan, secondSpan);
                Arrays.fill(this.data, 0, secondSpan, null);
                consumerIdx = secondSpan;
            }
            if (consumerIdx == this.capacity) {
                consumerIdx = 0;
            }
            this.consumerIdx = consumerIdx;
            if (this.size == this.capacity) {
                this.notFull.signalAll();
            }
            this.size -= toDrain;
            int n = toDrain;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            while (this.size > 0) {
                this.dequeueOne();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }
}

