/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.ConsumerIdentityWrapper;
import org.apache.pulsar.broker.service.ConsumerNameIndexTracker;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.util.Murmur3_32Hash;

public class ConsistentHashingStickyKeyConsumerSelector
implements StickyKeyConsumerSelector {
    private static final String KEY_SEPARATOR = "\u0000";
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final NavigableMap<Integer, ConsumerIdentityWrapper> hashRing;
    private final ConsumerNameIndexTracker consumerNameIndexTracker = new ConsumerNameIndexTracker();
    private final int numberOfPoints;

    public ConsistentHashingStickyKeyConsumerSelector(int numberOfPoints) {
        this.hashRing = new TreeMap<Integer, ConsumerIdentityWrapper>();
        this.numberOfPoints = numberOfPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> addConsumer(Consumer consumer) {
        this.rwLock.writeLock().lock();
        try {
            ConsumerIdentityWrapper consumerIdentityWrapper = new ConsumerIdentityWrapper(consumer);
            for (int i = 0; i < this.numberOfPoints; ++i) {
                int consumerNameIndex = this.consumerNameIndexTracker.increaseConsumerRefCountAndReturnIndex(consumerIdentityWrapper);
                int hash = ConsistentHashingStickyKeyConsumerSelector.calculateHashForConsumerAndIndex(consumer, consumerNameIndex, i);
                ConsumerIdentityWrapper removed = this.hashRing.put(hash, consumerIdentityWrapper);
                if (removed == null) continue;
                this.consumerNameIndexTracker.decreaseConsumerRefCount(removed);
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private static int calculateHashForConsumerAndIndex(Consumer consumer, int consumerNameIndex, int hashRingPointIndex) {
        String key = consumer.consumerName() + KEY_SEPARATOR + consumerNameIndex + KEY_SEPARATOR + hashRingPointIndex;
        return Murmur3_32Hash.getInstance().makeHash(key.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(Consumer consumer) {
        this.rwLock.writeLock().lock();
        try {
            ConsumerIdentityWrapper consumerIdentityWrapper = new ConsumerIdentityWrapper(consumer);
            int consumerNameIndex = this.consumerNameIndexTracker.getTrackedIndex(consumerIdentityWrapper);
            if (consumerNameIndex > -1) {
                for (int i = 0; i < this.numberOfPoints; ++i) {
                    int hash = ConsistentHashingStickyKeyConsumerSelector.calculateHashForConsumerAndIndex(consumer, consumerNameIndex, i);
                    if (!this.hashRing.remove(hash, consumerIdentityWrapper)) continue;
                    this.consumerNameIndexTracker.decreaseConsumerRefCount(consumerIdentityWrapper);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer select(int hash) {
        this.rwLock.readLock().lock();
        try {
            if (this.hashRing.isEmpty()) {
                Consumer consumer = null;
                return consumer;
            }
            Map.Entry<Integer, ConsumerIdentityWrapper> ceilingEntry = this.hashRing.ceilingEntry(hash);
            if (ceilingEntry != null) {
                Consumer consumer = ceilingEntry.getValue().consumer;
                return consumer;
            }
            Consumer consumer = this.hashRing.firstEntry().getValue().consumer;
            return consumer;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Consumer, List<Range>> getConsumerKeyHashRanges() {
        IdentityHashMap<Consumer, List<Range>> result = new IdentityHashMap<Consumer, List<Range>>();
        this.rwLock.readLock().lock();
        try {
            if (this.hashRing.isEmpty()) {
                IdentityHashMap<Consumer, List<Range>> identityHashMap = result;
                return identityHashMap;
            }
            int start = 0;
            int lastKey = 0;
            for (Map.Entry entry : this.hashRing.entrySet()) {
                Consumer consumer = ((ConsumerIdentityWrapper)entry.getValue()).consumer;
                result.computeIfAbsent(consumer, key -> new ArrayList()).add(Range.of((int)start, (int)((Integer)entry.getKey())));
                lastKey = (Integer)entry.getKey();
                start = lastKey + 1;
            }
            Consumer firstConsumer = this.hashRing.firstEntry().getValue().consumer;
            List ranges = (List)result.get(firstConsumer);
            if (lastKey != 0x7FFFFFFE) {
                ranges.add(Range.of((int)(lastKey + 1), (int)0x7FFFFFFE));
            }
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        return result;
    }
}

