/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStore;
import org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.IncrementRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.IncrementResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.PutResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.RangeResponse;
import org.apache.bookkeeper.stream.proto.kv.rpc.ResponseHeader;
import org.apache.bookkeeper.stream.proto.kv.rpc.RoutingHeader;
import org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.TxnResponse;
import org.apache.bookkeeper.stream.proto.storage.CreateNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.CreateNamespaceResponse;
import org.apache.bookkeeper.stream.proto.storage.CreateStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.CreateStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.DeleteNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.DeleteNamespaceResponse;
import org.apache.bookkeeper.stream.proto.storage.DeleteStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.DeleteStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.GetActiveRangesRequest;
import org.apache.bookkeeper.stream.proto.storage.GetActiveRangesResponse;
import org.apache.bookkeeper.stream.proto.storage.GetNamespaceRequest;
import org.apache.bookkeeper.stream.proto.storage.GetNamespaceResponse;
import org.apache.bookkeeper.stream.proto.storage.GetStreamRequest;
import org.apache.bookkeeper.stream.proto.storage.GetStreamResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;
import org.apache.bookkeeper.stream.protocol.RangeId;
import org.apache.bookkeeper.stream.protocol.util.StorageContainerPlacementPolicy;
import org.apache.bookkeeper.stream.storage.api.kv.TableStore;
import org.apache.bookkeeper.stream.storage.api.metadata.MetaRangeStore;
import org.apache.bookkeeper.stream.storage.api.metadata.RangeStoreService;
import org.apache.bookkeeper.stream.storage.api.metadata.RootRangeStore;
import org.apache.bookkeeper.stream.storage.impl.kv.TableStoreCache;
import org.apache.bookkeeper.stream.storage.impl.kv.TableStoreFactory;
import org.apache.bookkeeper.stream.storage.impl.kv.TableStoreImpl;
import org.apache.bookkeeper.stream.storage.impl.metadata.MetaRangeStoreFactory;
import org.apache.bookkeeper.stream.storage.impl.metadata.MetaRangeStoreImpl;
import org.apache.bookkeeper.stream.storage.impl.metadata.RootRangeStoreFactory;
import org.apache.bookkeeper.stream.storage.impl.metadata.RootRangeStoreImpl;
import org.apache.bookkeeper.stream.storage.impl.service.FailRequestRangeStoreService;
import org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RangeStoreServiceImpl
implements RangeStoreService,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RangeStoreServiceImpl.class);
    private final long scId;
    private final MVCCStoreFactory storeFactory;
    private MetaRangeStore mgStore;
    private final MetaRangeStoreFactory mrStoreFactory;
    private RootRangeStore rootRange;
    private final RootRangeStoreFactory rrStoreFactory;
    private final TableStoreCache tableStoreCache;
    private final TableStoreFactory tableStoreFactory;
    private final StorageServerClientManager clientManager;

    RangeStoreServiceImpl(long scId, StorageContainerPlacementPolicy rangePlacementPolicy, OrderedScheduler scheduler, MVCCStoreFactory storeFactory, StorageServerClientManager clientManager) {
        this(scId, scheduler, storeFactory, clientManager, store -> new RootRangeStoreImpl((MVCCAsyncStore<byte[], byte[]>)store, rangePlacementPolicy, (ScheduledExecutorService)scheduler.chooseThread(scId)), store -> new MetaRangeStoreImpl((MVCCAsyncStore<byte[], byte[]>)store, rangePlacementPolicy, (ScheduledExecutorService)scheduler.chooseThread(scId), clientManager), store -> new TableStoreImpl((MVCCAsyncStore<byte[], byte[]>)store));
    }

    RangeStoreServiceImpl(long scId, OrderedScheduler scheduler, MVCCStoreFactory storeFactory, StorageServerClientManager clientManager, RootRangeStoreFactory rrStoreFactory, MetaRangeStoreFactory mrStoreFactory, TableStoreFactory tableStoreFactory) {
        this.scId = scId;
        RangeStoreService failRequestStorageContainer = FailRequestRangeStoreService.of(scheduler);
        this.rootRange = failRequestStorageContainer;
        this.mgStore = failRequestStorageContainer;
        this.storeFactory = storeFactory;
        this.clientManager = clientManager;
        this.rrStoreFactory = rrStoreFactory;
        this.mrStoreFactory = mrStoreFactory;
        this.tableStoreFactory = tableStoreFactory;
        this.tableStoreCache = new TableStoreCache(storeFactory, tableStoreFactory);
    }

    private CompletableFuture<Integer> getStreamTtl(long streamId) {
        return streamId == 0L || streamId == 1L ? FutureUtils.value((Object)0) : this.clientManager.getStreamProperties(streamId).thenApply(r -> r.getStreamConf().getTtlSeconds());
    }

    public long getId() {
        return this.scId;
    }

    private CompletableFuture<Void> startRootRangeStore() {
        if (0L != this.scId) {
            return FutureUtils.Void();
        }
        return this.storeFactory.openStore(0L, 0L, 0L, 0).thenApply(store -> {
            this.rootRange = this.rrStoreFactory.createStore((MVCCAsyncStore<byte[], byte[]>)store);
            return null;
        });
    }

    private CompletableFuture<Void> startMetaRangeStore(long scId) {
        return this.storeFactory.openStore(scId, 1L, 0L, 0).thenApply(store -> {
            this.mgStore = this.mrStoreFactory.createStore((MVCCAsyncStore<byte[], byte[]>)store);
            return null;
        });
    }

    public CompletableFuture<Void> start() {
        ArrayList futures = Lists.newArrayList((Object[])new CompletableFuture[]{this.startRootRangeStore(), this.startMetaRangeStore(this.scId)});
        return FutureUtils.collect((List)futures).thenApply(ignored -> null);
    }

    public CompletableFuture<Void> stop() {
        return this.storeFactory.closeStores(this.scId);
    }

    @Override
    public void close() {
        this.stop().join();
    }

    public CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest request) {
        return this.rootRange.createNamespace(request);
    }

    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest request) {
        return this.rootRange.deleteNamespace(request);
    }

    public CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest request) {
        return this.rootRange.getNamespace(request);
    }

    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest request) {
        return this.rootRange.createStream(request);
    }

    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest request) {
        return this.rootRange.deleteStream(request);
    }

    public CompletableFuture<GetStreamResponse> getStream(GetStreamRequest request) {
        return this.rootRange.getStream(request);
    }

    public CompletableFuture<GetActiveRangesResponse> getActiveRanges(GetActiveRangesRequest request) {
        return this.mgStore.getActiveRanges(request);
    }

    private CompletableFuture<TableStore> getTableStore(long scId, RangeId rid) {
        TableStore store = this.tableStoreCache.getTableStore(rid);
        if (store != null) {
            return FutureUtils.value((Object)store);
        }
        return this.getStreamTtl(rid.getStreamId()).thenCompose(ttl -> this.tableStoreCache.openTableStore(scId, rid, (int)ttl));
    }

    public CompletableFuture<RangeResponse> range(RangeRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return FutureUtils.value((Object)RangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of((long)header.getStreamId(), (long)header.getRangeId());
        return this.getTableStore(this.scId, rid).thenCompose(s -> s.range(request));
    }

    public CompletableFuture<PutResponse> put(PutRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(PutResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of((long)header.getStreamId(), (long)header.getRangeId());
        return this.getTableStore(this.scId, rid).thenCompose(s -> s.put(request));
    }

    public CompletableFuture<DeleteRangeResponse> delete(DeleteRangeRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(DeleteRangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of((long)header.getStreamId(), (long)header.getRangeId());
        return this.getTableStore(this.scId, rid).thenCompose(s -> s.delete(request));
    }

    public CompletableFuture<TxnResponse> txn(TxnRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(TxnResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of((long)header.getStreamId(), (long)header.getRangeId());
        return this.getTableStore(this.scId, rid).thenCompose(s -> s.txn(request));
    }

    public CompletableFuture<IncrementResponse> incr(IncrementRequest request) {
        RoutingHeader header = request.getHeader();
        if (header.getRangeId() <= 0L) {
            return CompletableFuture.completedFuture(IncrementResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(StatusCode.BAD_REQUEST).setRoutingHeader(request.getHeader()).build()).build());
        }
        RangeId rid = RangeId.of((long)header.getStreamId(), (long)header.getRangeId());
        return this.getTableStore(this.scId, rid).thenCompose(s -> s.incr(request));
    }

    MetaRangeStore getMgStore() {
        return this.mgStore;
    }

    MetaRangeStoreFactory getMrStoreFactory() {
        return this.mrStoreFactory;
    }

    RootRangeStore getRootRange() {
        return this.rootRange;
    }

    RootRangeStoreFactory getRrStoreFactory() {
        return this.rrStoreFactory;
    }

    TableStoreCache getTableStoreCache() {
        return this.tableStoreCache;
    }

    TableStoreFactory getTableStoreFactory() {
        return this.tableStoreFactory;
    }
}

