/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.om.Item;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.StringValue;

public abstract class StringElaborator
extends Elaborator {
    public boolean returnZeroLengthWhenAbsent() {
        return false;
    }

    @Override
    public PullEvaluator elaborateForPull() {
        UnicodeStringEvaluator strEval = this.elaborateForUnicodeString(this.returnZeroLengthWhenAbsent());
        return context -> {
            UnicodeString value = strEval.eval(context);
            if (value == null) {
                return EmptyIterator.getInstance();
            }
            return SingletonIterator.makeIterator(StringValue.makeUStringValue(value));
        };
    }

    @Override
    public PushEvaluator elaborateForPush() {
        ItemEvaluator ie = this.elaborateForItem();
        return (out, context) -> {
            Item it = ie.eval(context);
            if (it != null) {
                out.append(it);
            }
            return null;
        };
    }

    @Override
    public ItemEvaluator elaborateForItem() {
        UnicodeStringEvaluator strEval = this.elaborateForUnicodeString(this.returnZeroLengthWhenAbsent());
        return context -> {
            UnicodeString value = strEval.eval(context);
            if (value == null) {
                return null;
            }
            return StringValue.makeUStringValue(value);
        };
    }

    @Override
    public BooleanEvaluator elaborateForBoolean() {
        UnicodeStringEvaluator strEval = this.elaborateForUnicodeString(this.returnZeroLengthWhenAbsent());
        return context -> {
            UnicodeString value = strEval.eval(context);
            return value != null && !value.isEmpty();
        };
    }

    @Override
    public abstract UnicodeStringEvaluator elaborateForUnicodeString(boolean var1);
}

