# completeWith

@@@ div { .group-scala }

## Signature

@@signature [MarshallingDirectives.scala](/http/src/main/scala/org/apache/pekko/http/scaladsl/server/directives/MarshallingDirectives.scala) { #completeWith }

@@@

## Description

Uses the marshaller for a given type to produce a completion function that is passed to its
inner route.  You can use it to decouple marshaller resolution from request completion.

The `completeWith` directive works in conjunction with the `instanceOf` directive
to convert higher-level (object) structure into some lower-level serialized "wire format".
@ref[The marshalling documentation](../../../common/marshalling.md) explains this process in detail.
This directive simplifies exposing types to clients via a route while providing some
form of access to the current context.

`completeWith` is similar to `handleWith`.  The main difference is with `completeWith` you must eventually call
the completion function generated by `completeWith`.  `handleWith` will automatically call `complete` when the
`handleWith` function returns.

## Examples

The following example uses @scala[`spray-json`]@java[@ref[Json Support via Jackson](../../../common/json-support.md#jackson-support)] to marshall a simple `Person` class to a json
response. @scala[It utilizes `SprayJsonSupport` via the `PersonJsonSupport` object as the in-scope
unmarshaller.]

Scala
:   @@snip [MarshallingDirectivesExamplesSpec.scala](/docs/src/test/scala/docs/http/scaladsl/server/directives/MarshallingDirectivesExamplesSpec.scala) { #person-json-support #person-case-class }

Java
:   @@snip [MarshallingDirectivesExamplesTest.java](/docs/src/test/java/docs/http/javadsl/server/directives/MarshallingDirectivesExamplesTest.java) { #person }

The `findPerson` takes an argument of type @scala[`Person => Unit`]@java[`Consumer<Consumer<Person>>`] which is generated by the `completeWith`
call.  We can handle any logic we want in `findPerson` and call our completion function to
complete the request.

Scala
:   @@snip [MarshallingDirectivesExamplesSpec.scala](/docs/src/test/scala/docs/http/scaladsl/server/directives/MarshallingDirectivesExamplesSpec.scala) { #example-completeWith-with-json }

Java
:   @@snip [MarshallingDirectivesExamplesTest.java](/docs/src/test/java/docs/http/javadsl/server/directives/MarshallingDirectivesExamplesTest.java) { #example-completeWith-with-json }
