/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.flagbitspane;

import javax.swing.JPanel;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.debugger.flagbitspane.AnnotFlag;
import org.apache.pdfbox.debugger.flagbitspane.EncryptFlag;
import org.apache.pdfbox.debugger.flagbitspane.FieldFlag;
import org.apache.pdfbox.debugger.flagbitspane.Flag;
import org.apache.pdfbox.debugger.flagbitspane.FlagBitsPaneView;
import org.apache.pdfbox.debugger.flagbitspane.FontFlag;
import org.apache.pdfbox.debugger.flagbitspane.PanoseFlag;
import org.apache.pdfbox.debugger.flagbitspane.SigFlag;
import org.apache.pdfbox.pdmodel.PDDocument;

public class FlagBitsPane {
    private FlagBitsPaneView view;
    private final PDDocument document;

    public FlagBitsPane(PDDocument document, COSDictionary dictionary, COSName flagType) {
        this.document = document;
        this.createPane(dictionary, flagType);
    }

    private void createPane(COSDictionary dictionary, COSName flagType) {
        Flag flag;
        if (COSName.FLAGS.equals(flagType)) {
            flag = new FontFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.F.equals(flagType)) {
            flag = new AnnotFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.FF.equals(flagType)) {
            flag = new FieldFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.PANOSE.equals(flagType)) {
            flag = new PanoseFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.P.equals(flagType)) {
            flag = new EncryptFlag(dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
        if (COSName.SIG_FLAGS.equals(flagType)) {
            flag = new SigFlag(this.document, dictionary);
            this.view = new FlagBitsPaneView(flag.getFlagType(), flag.getFlagValue(), flag.getFlagBits(), flag.getColumnNames());
        }
    }

    public JPanel getPane() {
        return this.view.getPanel();
    }
}

