/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValue;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTerminalField;

public class PDSignatureField
extends PDTerminalField {
    private static final Log LOG = LogFactory.getLog(PDSignatureField.class);

    public PDSignatureField(PDAcroForm acroForm) {
        super(acroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.SIG);
        PDAnnotationWidget firstWidget = this.getWidgets().get(0);
        firstWidget.setLocked(true);
        firstWidget.setPrinted(true);
        this.setPartialName(this.generatePartialName());
    }

    PDSignatureField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    private String generatePartialName() {
        String fieldName = "Signature";
        HashSet nameSet = new HashSet();
        this.getAcroForm().getFieldTree().forEach(field -> nameSet.add(field.getPartialName()));
        int i = 1;
        while (nameSet.contains(fieldName + i)) {
            ++i;
        }
        return fieldName + i;
    }

    public PDSignature getSignature() {
        return this.getValue();
    }

    public void setValue(PDSignature value) throws IOException {
        this.getCOSObject().setItem(COSName.V, (COSObjectable)value);
        this.applyChange();
    }

    @Override
    public void setValue(String value) {
        throw new UnsupportedOperationException("Signature fields don't support setting the value as String - use setValue(PDSignature value) instead");
    }

    public void setDefaultValue(PDSignature value) {
        this.getCOSObject().setItem(COSName.DV, (COSObjectable)value);
    }

    public PDSignature getValue() {
        COSDictionary value = this.getCOSObject().getCOSDictionary(COSName.V);
        return value != null ? new PDSignature(value) : null;
    }

    public PDSignature getDefaultValue() {
        COSDictionary value = this.getCOSObject().getCOSDictionary(COSName.DV);
        return value != null ? new PDSignature(value) : null;
    }

    @Override
    public String getValueAsString() {
        PDSignature signature = this.getValue();
        return signature != null ? signature.toString() : "";
    }

    public PDSeedValue getSeedValue() {
        COSDictionary dict = this.getCOSObject().getCOSDictionary(COSName.SV);
        return dict != null ? new PDSeedValue(dict) : null;
    }

    public void setSeedValue(PDSeedValue sv) {
        if (sv != null) {
            this.getCOSObject().setItem(COSName.SV, (COSObjectable)sv);
        }
    }

    @Override
    void constructAppearances() throws IOException {
        PDAnnotationWidget widget = this.getWidgets().get(0);
        if (widget != null) {
            PDRectangle rectangle = widget.getRectangle();
            if (rectangle == null || Float.compare(rectangle.getHeight(), 0.0f) == 0 && Float.compare(rectangle.getWidth(), 0.0f) == 0 || widget.isNoView() || widget.isHidden()) {
                return;
            }
            LOG.warn("Appearance generation for signature fields not implemented here. You need to generate/update that manually, see the CreateVisibleSignature*.java files in the examples subproject of the source code download");
        }
    }
}

