/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.innosetup;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.AbstractPackagerTask;
import org.apache.netbeans.nbpackage.Architecture;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.FileUtils;
import org.apache.netbeans.nbpackage.NBPackage;
import org.apache.netbeans.nbpackage.StringUtils;
import org.apache.netbeans.nbpackage.innosetup.InnoSetupPackager;

class InnoSetupTask
extends AbstractPackagerTask {
    InnoSetupTask(ExecutionContext context) {
        super(context);
    }

    @Override
    protected void checkImageRequirements() throws Exception {
        this.context().getValue(NBPackage.PACKAGE_ARCH).ifPresent(arch -> {
            if (!Architecture.X86_64.isSynonym((String)arch)) {
                this.context().warningHandler().accept(InnoSetupPackager.MESSAGES.getString("message.invalidarch"));
            }
        });
    }

    @Override
    protected void checkPackageRequirements() throws Exception {
        this.context().getValue(InnoSetupPackager.TOOL_PATH).orElseThrow(() -> new IllegalStateException(InnoSetupPackager.MESSAGES.getString("message.noinnosetuptool")));
    }

    @Override
    protected void customizeImage(Path image) throws Exception {
        String execName = this.findExecName(image.resolve("APPDIR").resolve("bin"));
        Path appDir = image.resolve(execName);
        Files.move(image.resolve("APPDIR"), appDir, new CopyOption[0]);
        this.setupIcons(image, execName);
        this.setupLicenseFile(image);
    }

    @Override
    protected void finalizeImage(Path image) throws Exception {
        String execName = this.findExecName(FileUtils.find(image, "*/bin").get(0));
        this.createInnoSetupScript(image, execName);
    }

    @Override
    protected Path buildPackage(Path image) throws Exception {
        Path exeFile;
        Path issFile;
        Path tool = this.context().getValue(InnoSetupPackager.TOOL_PATH).orElseThrow(() -> new IllegalStateException(InnoSetupPackager.MESSAGES.getString("message.noinnosetuptool"))).toAbsolutePath();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(image, "*.iss");){
            Iterator<Path> itr = stream.iterator();
            if (!itr.hasNext()) {
                throw new IllegalArgumentException(image.toString());
            }
            issFile = itr.next();
        }
        List<String> cmd = List.of(tool.toString(), issFile.getFileName().toString());
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(image.toFile());
        this.context().exec(pb);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(image.resolve("Output"), "*.exe");){
            Iterator<Path> itr = stream.iterator();
            if (!itr.hasNext()) {
                throw new IllegalArgumentException(image.toString());
            }
            exeFile = itr.next();
        }
        Path output = this.context().destination().resolve(exeFile.getFileName());
        Files.move(exeFile, output, new CopyOption[0]);
        Files.delete(image.resolve("Output"));
        return output;
    }

    @Override
    protected String calculateImageName(Path input) throws Exception {
        return super.calculateImageName(input) + "-InnoSetup";
    }

    @Override
    protected Path calculateAppPath(Path image) throws Exception {
        return image.resolve("APPDIR");
    }

    @Override
    protected Path calculateRuntimePath(Path image, Path application) throws Exception {
        return application.resolve("jdk");
    }

    @Override
    protected Path calculateRootPath(Path image) throws Exception {
        return FileUtils.find(image, "*/bin").get(0).getParent();
    }

    private Path findLauncher(Path binDir) throws IOException {
        try (Stream<Path> files = Files.list(binDir);){
            Path path = files.filter(f -> f.getFileName().toString().endsWith("64.exe")).findFirst().orElseThrow(IOException::new);
            return path;
        }
    }

    private String findExecName(Path binDir) throws IOException {
        Path bin = this.findLauncher(binDir);
        String name = bin.getFileName().toString();
        return name.substring(0, name.length() - "64.exe".length());
    }

    private void setupIcons(Path image, String execName) throws IOException {
        Path icoFile = this.context().getValue(InnoSetupPackager.ICON_PATH).orElse(null);
        Path dstFile = image.resolve(execName).resolve("etc").resolve(execName + ".ico");
        if (icoFile != null) {
            Files.copy(icoFile, dstFile, new CopyOption[0]);
        } else {
            Files.copy(this.getClass().getResourceAsStream("/org/apache/netbeans/nbpackage/apache-netbeans.ico"), dstFile, new CopyOption[0]);
        }
    }

    private void setupLicenseFile(Path image) throws IOException {
        Path license = this.context().getValue(InnoSetupPackager.LICENSE_PATH).orElse(null);
        if (license == null) {
            return;
        }
        String name = license.getFileName().toString().toLowerCase(Locale.ROOT);
        boolean isTXT = name.endsWith(".txt");
        boolean isRTF = name.endsWith(".rtf");
        if (!isTXT && !isRTF) {
            throw new IllegalArgumentException(license.toString());
        }
        Path target = image.resolve(isTXT ? "license.txt" : "license.rtf");
        Files.copy(license, target, new CopyOption[0]);
    }

    private void createInnoSetupScript(Path image, String execName) throws IOException {
        List<Path> files;
        String template = InnoSetupPackager.ISS_TEMPLATE.load(this.context()).lines().collect(Collectors.joining("\r\n", "", "\r\n"));
        try (Stream<Path> l = Files.list(image.resolve(execName));){
            files = l.sorted().collect(Collectors.toList());
        }
        String installDeleteSection = this.buildInstallDeleteSection(files);
        String filesSection = this.buildFilesSection(execName, files);
        String appName = this.context().getValue(NBPackage.PACKAGE_NAME).orElse(execName);
        String appNameSafe = this.sanitize(appName);
        String appID = this.context().getValue(InnoSetupPackager.APPID).orElse(appName);
        String appVersion = this.context().getValue(NBPackage.PACKAGE_VERSION).orElse("1.0");
        String appPublisher = this.context().getValue(NBPackage.PACKAGE_PUBLISHER).map(pub -> "AppPublisher=" + pub).orElse("");
        String appURL = this.context().getValue(NBPackage.PACKAGE_URL).map(url -> "AppPublisherURL=" + String.valueOf(url)).orElse("");
        String appLicense = Files.exists(image.resolve("license.txt"), new LinkOption[0]) ? "LicenseFile=license.txt" : (Files.exists(image.resolve("license.rtf"), new LinkOption[0]) ? "LicenseFile=license.rtf" : "");
        String execParam = this.context().getValue(NBPackage.PACKAGE_RUNTIME).map(p -> "Parameters: \"--jdkhome \"\"{app}\\jdk\"\"\";").orElse("");
        String outputFilename = appNameSafe.replaceAll("\\s", "-") + "-" + this.sanitize(appVersion).replaceAll("\\s", "-") + this.context().getValue(NBPackage.PACKAGE_ARCH).map(arch -> "-" + this.sanitize((String)arch).replaceAll("\\s", "")).orElse("");
        Map<String, String> map = Map.ofEntries(Map.entry("APP_ID", appID), Map.entry("APP_NAME", appName), Map.entry("APP_NAME_SAFE", appNameSafe), Map.entry("APP_VERSION", appVersion), Map.entry("APP_PUBLISHER", appPublisher), Map.entry("APP_PUBLISHER_URL", appURL), Map.entry("APP_LICENSE", appLicense), Map.entry("OUTPUT_FILENAME", outputFilename), Map.entry("INSTALL_DELETE", installDeleteSection), Map.entry("FILES", filesSection), Map.entry("EXEC_NAME", execName), Map.entry("PARAMETERS", execParam));
        String script = StringUtils.replaceTokens(template, map);
        Files.writeString(image.resolve(execName + ".iss"), (CharSequence)script, StandardOpenOption.CREATE_NEW);
    }

    private String sanitize(String name) {
        return name.replaceAll("[\\\\/:*?\"<>|]", "_");
    }

    private String buildInstallDeleteSection(List<Path> files) {
        return files.stream().map(Path::getFileName).map(Path::toString).map(name -> "Type: filesandordirs; Name: \"{app}\\" + name + "\"").collect(Collectors.joining("\r\n", "", "\r\n"));
    }

    private String buildFilesSection(String execName, List<Path> files) {
        return files.stream().map(file -> this.buildFilesSectionLine(execName, (Path)file)).collect(Collectors.joining("\r\n", "", "\r\n"));
    }

    private String buildFilesSectionLine(String execName, Path file) {
        boolean isDir = Files.isDirectory(file, new LinkOption[0]);
        String fileName = file.getFileName().toString();
        if (isDir) {
            return "Source: \"" + execName + "\\" + fileName + "\\*\"; DestDir: \"{app}\\" + fileName + "\"; Flags: ignoreversion recursesubdirs createallsubdirs";
        }
        return "Source: \"" + execName + "\\" + fileName + "\"; DestDir: \"{app}\"; Flags: ignoreversion";
    }
}

