/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Component;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.actions.AutoupdateCheckScheduler;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LazyInstallUnitWizardIterator;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionPanel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.PanelBodyContainer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class LazyOperationDescriptionStep
implements WizardDescriptor.Panel<WizardDescriptor> {
    private static final String HEAD = "OperationDescriptionStep_Header_Head";
    private static final String CONTENT = "OperationDescriptionStep_Header_Content";
    private static final String TABLE_TITLE_INSTALL = "OperationDescriptionStep_TableInstall_Title";
    private static final String TABLE_TITLE_UPDATE = "OperationDescriptionStep_TableUpdate_Title";
    private PanelBodyContainer component;
    private Collection<LazyInstallUnitWizardIterator.LazyUnit> installModel = null;
    private boolean hasUpdates = false;
    private OperationWizardModel.OperationType operationType = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private RequestProcessor.Task checkRealUpdatesTask = null;
    private WizardDescriptor wd = null;
    private boolean forceReload;
    private boolean canClose = false;

    public LazyOperationDescriptionStep(Collection<LazyInstallUnitWizardIterator.LazyUnit> model, OperationWizardModel.OperationType doOperation, boolean forceReload) {
        this.installModel = model;
        this.operationType = doOperation;
        this.hasUpdates = this.installModel != null && !this.installModel.isEmpty();
        this.forceReload = forceReload;
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            String content;
            String head;
            String tableTitle;
            switch (this.operationType) {
                case INSTALL: {
                    tableTitle = this.getBundle(TABLE_TITLE_INSTALL, new Object[0]);
                    head = this.getBundle(HEAD, new Object[0]);
                    content = this.getBundle(CONTENT, new Object[0]);
                    break;
                }
                case UPDATE: {
                    tableTitle = this.getBundle(TABLE_TITLE_UPDATE, new Object[0]);
                    head = this.getBundle(HEAD, new Object[0]);
                    content = this.getBundle(CONTENT, new Object[0]);
                    break;
                }
                default: {
                    assert (false) : "Unexcepted operationType " + (Object)((Object)this.operationType);
                    return null;
                }
            }
            if (!this.hasUpdates) {
                tableTitle = this.getBundle("LazyOperationDescriptionStep_FindUpdates_Title", new Object[0]);
            }
            OperationDescriptionPanel body = new OperationDescriptionPanel(tableTitle, this.preparePluginsForShow(this.installModel, this.operationType), "", "", false);
            this.component = new PanelBodyContainer(head, content, body);
            this.component.setPreferredSize(OperationWizardModel.PREFFERED_DIMENSION);
            long estimatedTime = Utilities.getTimeOfInitialization();
            if (this.forceReload) {
                long refreshTime = Utilities.getTimeOfRefreshUpdateCenters();
                estimatedTime = estimatedTime > 0L || refreshTime > 0L ? estimatedTime + refreshTime : 0L;
            }
            this.component.setWaitingState(true, estimatedTime);
            this.checkRealUpdates();
        }
        return this.component;
    }

    private void checkRealUpdates() {
        final ArrayList problems = new ArrayList();
        this.checkRealUpdatesTask = Installer.RP.post(new Runnable(){

            @Override
            public void run() {
                final HashSet<UpdateElement> updateElementsForStore = new HashSet<UpdateElement>();
                Collection<UpdateElement> updates = AutoupdateCheckScheduler.checkUpdateElements(LazyOperationDescriptionStep.this.operationType, problems, LazyOperationDescriptionStep.this.forceReload, updateElementsForStore);
                LazyOperationDescriptionStep.this.hasUpdates = updates != null && !updates.isEmpty();
                if (LazyOperationDescriptionStep.this.hasUpdates) {
                    UpdateUnit uu;
                    assert (LazyOperationDescriptionStep.this.wd != null) : "WizardDescriptor must found!";
                    OperationContainer<InstallSupport> oc = OperationWizardModel.OperationType.UPDATE == LazyOperationDescriptionStep.this.operationType ? OperationContainer.createForUpdate() : OperationContainer.createForInstall();
                    boolean allOk = true;
                    InstallUnitWizardModel model = new InstallUnitWizardModel(LazyOperationDescriptionStep.this.operationType, oc);
                    for (UpdateElement el : updates) {
                        uu = el.getUpdateUnit();
                        if (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == uu.getType()) {
                            allOk &= model.getCustomHandledContainer().canBeAdded(uu, el);
                            continue;
                        }
                        allOk &= oc.canBeAdded(uu, el);
                    }
                    LazyOperationDescriptionStep.this.hasUpdates = LazyOperationDescriptionStep.this.hasUpdates && allOk;
                    if (allOk) {
                        for (UpdateElement el : updates) {
                            uu = el.getUpdateUnit();
                            if (UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT == uu.getType()) {
                                model.getCustomHandledContainer().add(el);
                                continue;
                            }
                            oc.add(el);
                        }
                        model.getBaseContainer().listAll();
                        final InstallUnitWizardIterator panels = new InstallUnitWizardIterator(model, true);
                        panels.hasNext();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LazyOperationDescriptionStep.this.wd.setPanelsAndSettings(panels, LazyOperationDescriptionStep.this.wd);
                                LazyOperationDescriptionStep.this.fireChange();
                                LazyInstallUnitWizardIterator.LazyUnit.storeUpdateElements(LazyOperationDescriptionStep.this.operationType, updateElementsForStore);
                            }
                        });
                    }
                }
            }
        });
        class TLAndR
        implements TaskListener,
        Runnable {
            TLAndR() {
            }

            @Override
            public void taskFinished(Task task) {
                task.removeTaskListener(this);
                if (!LazyOperationDescriptionStep.this.hasUpdates) {
                    LazyOperationDescriptionStep.this.installModel = Collections.EMPTY_SET;
                    new InstallUnitWizardModel(null, null).modifyOptionsForDoClose(LazyOperationDescriptionStep.this.wd);
                    LazyOperationDescriptionStep.this.canClose = true;
                    LazyInstallUnitWizardIterator.LazyUnit.storeLazyUnits(LazyOperationDescriptionStep.this.operationType, LazyOperationDescriptionStep.this.installModel);
                    EventQueue.invokeLater(this);
                }
            }

            @Override
            public void run() {
                OperationDescriptionPanel body = problems == null || problems.isEmpty() ? new OperationDescriptionPanel(LazyOperationDescriptionStep.this.getBundle("LazyOperationDescriptionStep_NoUpdates_Title", new Object[0]), LazyOperationDescriptionStep.this.getBundle("LazyOperationDescriptionStep_NoUpdates", new Object[0]), "", "", false) : new OperationDescriptionPanel(LazyOperationDescriptionStep.this.getBundle("LazyOperationDescriptionStep_NoUpdatesWithProblems_Title", new Object[0]), LazyOperationDescriptionStep.this.getBundle("LazyOperationDescriptionStep_NoUpdatesWithProblems", new Object[0]), "", "", false);
                LazyOperationDescriptionStep.this.component.setBody(body);
                LazyOperationDescriptionStep.this.component.setWaitingState(false);
                LazyOperationDescriptionStep.this.fireChange();
            }
        }
        this.checkRealUpdatesTask.addTaskListener(new TLAndR());
    }

    private String preparePluginsForShow(Collection<LazyInstallUnitWizardIterator.LazyUnit> units, OperationWizardModel.OperationType type) {
        String s = new String();
        ArrayList<String> names = new ArrayList<String>();
        if (units != null && !units.isEmpty()) {
            for (LazyInstallUnitWizardIterator.LazyUnit u : units) {
                String updatename = "<b>" + u.getDisplayName() + "</b> ";
                updatename = OperationWizardModel.OperationType.UPDATE == type ? updatename + this.getBundle("OperationDescriptionStep_UpdatePluginVersionFormat", u.getOldVersion(), u.getNewVersion()) : updatename + this.getBundle("OperationDescriptionStep_PluginVersionFormat", u.getNewVersion());
                updatename = updatename + "<br>";
                String notification = u.getNotification();
                if (notification != null && notification.length() > 0) {
                    updatename = updatename + "<font color=\"red\">" + notification + "</font><br><br>";
                }
                names.add(updatename);
            }
            Collections.sort(names);
            for (String name : names) {
                s = s + name;
            }
        }
        return s.trim();
    }

    @Override
    public HelpCtx getHelp() {
        return null;
    }

    @Override
    public void readSettings(WizardDescriptor wd) {
        this.wd = wd;
    }

    @Override
    public void storeSettings(WizardDescriptor wd) {
        if (WizardDescriptor.CANCEL_OPTION.equals(wd.getValue()) || WizardDescriptor.CLOSED_OPTION.equals(wd.getValue())) {
            if (this.checkRealUpdatesTask != null && !this.checkRealUpdatesTask.isFinished()) {
                this.checkRealUpdatesTask.cancel();
            }
            AutoupdateCheckScheduler.notifyAvailable(this.installModel, this.operationType);
        }
    }

    @Override
    public boolean isValid() {
        return this.canClose;
    }

    @Override
    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> templist;
        ChangeEvent e = new ChangeEvent(this);
        LazyOperationDescriptionStep lazyOperationDescriptionStep = this;
        synchronized (lazyOperationDescriptionStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(OperationDescriptionPanel.class, key, params);
    }
}

