/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context;

import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerWrapper;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.faces.event.SystemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.lifecycle.ViewNotFoundException;
import org.apache.myfaces.renderkit.ErrorPageWriter;
import org.apache.myfaces.shared.util.WebConfigParamUtils;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.WebConfigProviderFactory;

public class MyFacesExceptionHandlerWrapperImpl
extends ExceptionHandlerWrapper {
    private static final Logger log = Logger.getLogger(MyFacesExceptionHandlerWrapperImpl.class.getName());
    private Queue<ExceptionQueuedEvent> handled;
    private Queue<ExceptionQueuedEvent> unhandled;
    private ExceptionQueuedEvent handledAndThrown;
    private ExceptionHandler _delegate;
    private boolean _isErrorPagePresent;
    private boolean _useMyFacesErrorHandling;
    private boolean _inited;

    public MyFacesExceptionHandlerWrapperImpl(ExceptionHandler delegate) {
        this._delegate = delegate;
        this._inited = false;
    }

    protected void init() {
        if (!this._inited) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            WebConfigProvider webConfigProvider = WebConfigProviderFactory.getWebConfigProviderFactory(facesContext.getExternalContext()).getWebConfigProvider(facesContext.getExternalContext());
            this._isErrorPagePresent = webConfigProvider.isErrorPagePresent(facesContext.getExternalContext());
            this._useMyFacesErrorHandling = WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.ERROR_HANDLING", facesContext.isProjectStage(ProjectStage.Development));
            this._inited = true;
        }
    }

    protected void init(FacesContext facesContext) {
        if (!this._inited) {
            if (facesContext == null) {
                facesContext = FacesContext.getCurrentInstance();
            }
            WebConfigProvider webConfigProvider = WebConfigProviderFactory.getWebConfigProviderFactory(facesContext.getExternalContext()).getWebConfigProvider(facesContext.getExternalContext());
            this._isErrorPagePresent = webConfigProvider.isErrorPagePresent(facesContext.getExternalContext());
            this._useMyFacesErrorHandling = WebConfigParamUtils.getBooleanInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.ERROR_HANDLING", facesContext.isProjectStage(ProjectStage.Development));
            this._inited = true;
        }
    }

    protected void init(SystemEvent exceptionQueuedEvent) {
        if (!this._inited) {
            FacesContext facesContext;
            ExceptionQueuedEvent eqe;
            ExceptionQueuedEventContext eqec;
            if (exceptionQueuedEvent instanceof ExceptionQueuedEvent && (eqec = (eqe = (ExceptionQueuedEvent)exceptionQueuedEvent).getContext()) != null && (facesContext = eqec.getContext()) != null) {
                this.init(facesContext);
                return;
            }
            this.init(FacesContext.getCurrentInstance());
        }
    }

    protected boolean isUseMyFacesErrorHandling() {
        return this._useMyFacesErrorHandling;
    }

    protected boolean isErrorPagePresent() {
        return this._isErrorPagePresent;
    }

    @Override
    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        this.init();
        if (!this.isUseMyFacesErrorHandling()) {
            return super.getHandledExceptionQueuedEvent();
        }
        return this.handledAndThrown;
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        this.init();
        if (!this.isUseMyFacesErrorHandling()) {
            return super.getHandledExceptionQueuedEvents();
        }
        return this.handled == null ? Collections.emptyList() : this.handled;
    }

    @Override
    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        this.init();
        if (!this.isUseMyFacesErrorHandling()) {
            return super.getUnhandledExceptionQueuedEvents();
        }
        return this.unhandled == null ? Collections.emptyList() : this.unhandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() throws FacesException {
        this.init();
        if (!this.isUseMyFacesErrorHandling()) {
            if (this.isErrorPagePresent()) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                facesContext.getExternalContext().getRequestMap().put("org.apache.myfaces.error.UIViewRoot", facesContext.getViewRoot());
            }
            try {
                super.handle();
            }
            catch (FacesException e) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                if (e.getCause() instanceof ViewNotFoundException) {
                    facesContext.getExternalContext().setResponseStatus(404);
                } else {
                    facesContext.getExternalContext().setResponseStatus(500);
                }
                throw e;
            }
            return;
        }
        if (this.unhandled != null && !this.unhandled.isEmpty()) {
            if (this.handled == null) {
                this.handled = new LinkedList<ExceptionQueuedEvent>();
            }
            ArrayList<Throwable> throwableList = new ArrayList<Throwable>();
            ArrayList<UIComponent> components = new ArrayList<UIComponent>();
            FacesContext facesContext = null;
            do {
                ExceptionQueuedEvent event = this.unhandled.peek();
                try {
                    Throwable exception;
                    ExceptionQueuedEventContext context = event.getContext();
                    if (facesContext == null) {
                        facesContext = event.getContext().getContext();
                    }
                    if (!this.shouldSkip(exception = context.getException())) {
                        this.handledAndThrown = event;
                        Throwable rootCause = this.getRootCause(exception);
                        throwableList.add(rootCause == null ? exception : rootCause);
                        components.add(event.getContext().getComponent());
                        continue;
                    }
                    log.log(Level.SEVERE, exception.getClass().getName() + " occured while processing " + (context.inBeforePhase() ? "beforePhase() of " : (context.inAfterPhase() ? "afterPhase() of " : "")) + "phase " + context.getPhaseId() + ": UIComponent-ClientId=" + (context.getComponent() != null ? context.getComponent().getClientId(context.getContext()) : "") + ", Message=" + exception.getMessage());
                    log.log(Level.SEVERE, exception.getMessage(), exception);
                }
                finally {
                    this.handled.add(event);
                    this.unhandled.remove(event);
                }
            } while (!this.unhandled.isEmpty());
            if (facesContext == null) {
                facesContext = FacesContext.getCurrentInstance();
            }
            if (throwableList.size() == 1) {
                ErrorPageWriter.handle(facesContext, components, (Throwable)throwableList.get(0));
            } else if (throwableList.size() > 1) {
                ErrorPageWriter.handle(facesContext, components, throwableList.toArray(new Throwable[throwableList.size()]));
            }
        }
    }

    @Override
    public void processEvent(SystemEvent exceptionQueuedEvent) throws AbortProcessingException {
        this.init(exceptionQueuedEvent);
        if (!this.isUseMyFacesErrorHandling()) {
            super.processEvent(exceptionQueuedEvent);
        } else {
            if (this.unhandled == null) {
                this.unhandled = new LinkedList<ExceptionQueuedEvent>();
            }
            this.unhandled.add((ExceptionQueuedEvent)exceptionQueuedEvent);
        }
    }

    protected Throwable getRethrownException(Throwable exception) {
        Throwable toRethrow = this.getRootCause(exception);
        if (toRethrow == null) {
            toRethrow = exception;
        }
        return toRethrow;
    }

    protected FacesException wrap(Throwable exception) {
        if (exception instanceof FacesException) {
            return (FacesException)exception;
        }
        return new FacesException(exception);
    }

    protected boolean shouldSkip(Throwable exception) {
        return exception instanceof AbortProcessingException;
    }

    @Override
    public ExceptionHandler getWrapped() {
        return this._delegate;
    }
}

