/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.myfaces.util.LocaleUtils;
import org.apache.myfaces.view.ServletViewResponseWrapper;

public class ViewTag
extends UIComponentELTag {
    private static final Logger log = Logger.getLogger(ViewTag.class.getName());
    private ValueExpression _locale;
    private ValueExpression _renderKitId;
    private MethodExpression _beforePhase;
    private MethodExpression _afterPhase;

    public String getComponentType() {
        return "javax.faces.ViewRoot";
    }

    public String getRendererType() {
        return null;
    }

    public void setLocale(ValueExpression locale) {
        this._locale = locale;
    }

    public void setRenderKitId(ValueExpression renderKitId) {
        this._renderKitId = renderKitId;
    }

    public void setBeforePhase(MethodExpression beforePhase) {
        this._beforePhase = beforePhase;
    }

    public void setAfterPhase(MethodExpression afterPhase) {
        this._afterPhase = afterPhase;
    }

    public int doStartTag() throws JspException {
        FacesContext facesContext;
        Object response;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("entering ViewTag.doStartTag");
        }
        if ((response = (facesContext = FacesContext.getCurrentInstance()).getExternalContext().getResponse()) instanceof ServletViewResponseWrapper) {
            try {
                this.pageContext.getOut().flush();
                ((ServletViewResponseWrapper)response).flushToWrappedResponse();
            }
            catch (IOException e) {
                throw new JspException("Can't write content above <f:view> tag " + e.getMessage());
            }
        }
        int retVal = super.doStartTag();
        Config.set((ServletRequest)this.pageContext.getRequest(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)facesContext.getViewRoot().getLocale());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("leaving ViewTag.doStartTag");
        }
        return retVal;
    }

    public int doEndTag() throws JspException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("entering ViewTag.doEndTag");
        }
        int retVal = super.doEndTag();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("leaving ViewTag.doEndTag");
        }
        return retVal;
    }

    public int doAfterBody() throws JspException {
        UIComponent verbatimComp;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("entering ViewTag.doAfterBody");
        }
        if ((verbatimComp = this.createVerbatimComponentFromBodyContent()) != null) {
            FacesContext.getCurrentInstance().getViewRoot().getChildren().add(verbatimComp);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("leaving ViewTag.doAfterBody");
        }
        return 6;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        UIViewRoot viewRoot = (UIViewRoot)component;
        if (this._locale != null) {
            Locale locale;
            if (this._locale.isLiteralText()) {
                locale = LocaleUtils.toLocale(this._locale.getValue(elContext).toString());
            } else {
                component.setValueExpression("locale", this._locale);
                Object localeValue = this._locale.getValue(elContext);
                if (localeValue instanceof Locale) {
                    locale = (Locale)localeValue;
                } else if (localeValue instanceof String) {
                    locale = LocaleUtils.toLocale((String)localeValue);
                } else {
                    if (localeValue != null) {
                        throw new IllegalArgumentException("Locale or String class expected. Expression: " + this._locale + ". Return class: " + localeValue.getClass().getName());
                    }
                    throw new IllegalArgumentException("Locale or String class expected. Expression: " + this._locale + ". Return value null");
                }
            }
            viewRoot.setLocale(locale);
            Config.set((ServletRequest)this.pageContext.getRequest(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
        }
        if (this._renderKitId != null) {
            if (this._renderKitId.isLiteralText()) {
                viewRoot.setRenderKitId(this._renderKitId.getValue(elContext).toString());
            } else {
                viewRoot.setValueExpression("renderKitId", this._renderKitId);
                viewRoot.setRenderKitId(null);
            }
        } else if (viewRoot.getRenderKitId() == null) {
            String defaultRenderKitId = facesContext.getApplication().getDefaultRenderKitId();
            if (defaultRenderKitId != null) {
                viewRoot.setRenderKitId(defaultRenderKitId);
            } else {
                viewRoot.setRenderKitId("HTML_BASIC");
            }
        }
        if (this._beforePhase != null) {
            if (this._beforePhase.isLiteralText()) {
                throw new FacesException("Invalid method expression for attribute 'beforePhase' in the view tag: " + this._beforePhase.getExpressionString());
            }
            viewRoot.setBeforePhaseListener(this._beforePhase);
        }
        if (this._afterPhase != null) {
            if (this._afterPhase.isLiteralText()) {
                throw new FacesException("Invalid method expression for attribute 'beforePhase' in the view tag: " + this._afterPhase.getExpressionString());
            }
            viewRoot.setAfterPhaseListener(this._afterPhase);
        }
    }
}

