/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.CommonEventUtils;
import org.apache.myfaces.renderkit.html.util.CommonPropertyUtils;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public class HtmlImageRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlImageRendererBase.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        ClientBehaviorRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Level level;
        RendererUtils.checkParamValidity(facesContext, uiComponent, UIGraphic.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        }
        writer.startElement("img", uiComponent);
        if (uiComponent instanceof ClientBehaviorHolder && !behaviors.isEmpty()) {
            HtmlRendererUtils.writeIdAndName(writer, uiComponent, facesContext);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        }
        String url = RendererUtils.getIconSrc(facesContext, uiComponent, "url");
        if (url != null) {
            writer.writeURIAttribute("src", (Object)url, "value");
        } else {
            Level level2 = level = facesContext.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
            if (log.isLoggable(level)) {
                log.log(level, "Component UIGraphic " + uiComponent.getClientId(facesContext) + " has no attribute url, value, name or attribute resolves to null. Path to component " + ComponentUtils.getPathToComponent((UIComponent)uiComponent));
            }
        }
        if (uiComponent.getAttributes().get("alt") == null) {
            Level level3 = level = facesContext.isProjectStage(ProjectStage.Production) ? Level.FINE : Level.WARNING;
            if (log.isLoggable(level)) {
                log.log(level, "Component UIGraphic " + uiComponent.getClientId(facesContext) + " has no attribute alt or attribute resolves to null. Path to component " + ComponentUtils.getPathToComponent((UIComponent)uiComponent));
            }
        }
        if (uiComponent instanceof ClientBehaviorHolder) {
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderEventProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), CommonEventUtils.getCommonEventsMarked(uiComponent), uiComponent, behaviors);
            } else {
                HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, uiComponent, behaviors);
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
                CommonPropertyUtils.renderCommonPassthroughPropertiesWithoutEvents(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_ATTRIBUTES);
            CommonPropertyUtils.renderCommonPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(uiComponent), uiComponent);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.IMG_PASSTHROUGH_ATTRIBUTES);
        }
        writer.endElement("img");
    }
}

