/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;

class _ComponentChildrenList
extends AbstractList
implements Serializable {
    private static final long serialVersionUID = -6775078929331154224L;
    private UIComponent _component;
    private List _list = new ArrayList();
    private Map _idIndexedMap = new HashMap();

    _ComponentChildrenList(UIComponent component) {
        this._component = component;
    }

    public UIComponent get(String id) {
        return (UIComponent)this._idIndexedMap.get(id);
    }

    public Object get(int index) {
        return this._list.get(index);
    }

    public int size() {
        return this._list.size();
    }

    public Object set(int index, Object value) {
        this.checkValue(value);
        this.setNewParent((UIComponent)value);
        UIComponent child = (UIComponent)this._list.set(index, value);
        this.resetParent(child);
        return child;
    }

    public boolean add(Object value) {
        this.checkValue(value);
        this.setNewParent((UIComponent)value);
        return this._list.add(value);
    }

    public void add(int index, Object value) {
        this.checkValue(value);
        this.setNewParent((UIComponent)value);
        this._list.add(index, value);
    }

    public Object remove(int index) {
        UIComponent child = (UIComponent)this._list.remove(index);
        this.resetParent(child);
        return child;
    }

    private void setNewParent(UIComponent child) {
        UIComponent oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.getChildren().remove(child);
        }
        child.setParent(this._component);
        this._idIndexedMap.put(child.getId(), child);
    }

    private void resetParent(UIComponent child) {
        if (child != null) {
            child.setParent(null);
        }
        this._idIndexedMap.remove(child.getId());
    }

    private void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (!(value instanceof UIComponent)) {
            throw new ClassCastException("value is not a UIComponent");
        }
    }

    public void updateId(String oldId, UIComponent component) {
        this._idIndexedMap.remove(oldId);
        this._idIndexedMap.put(component.getId(), component);
    }
}

