/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.util;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.servlet.jsp.el.ELException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_impl.util._Constants;
import org.apache.myfaces.shared_impl.util._MessageUtil;
import org.apache.myfaces.shared_impl.util._PrimitiveObjects;

class _Coercions {
    private static final Number ZERO = new Integer(0);
    private static Log log = LogFactory.getLog((Class)_Coercions.class);

    _Coercions() {
    }

    public static Object coerce(Object pValue, Class pClass) throws ELException {
        if (pClass == String.class) {
            return _Coercions.coerceToString(pValue);
        }
        if (_Coercions.isNumberClass(pClass)) {
            return _Coercions.coerceToPrimitiveNumber(pValue, pClass);
        }
        if (pClass == Character.class || pClass == Character.TYPE) {
            return _Coercions.coerceToCharacter(pValue);
        }
        if (pClass == Boolean.class || pClass == Boolean.TYPE) {
            return _Coercions.coerceToBoolean(pValue);
        }
        return _Coercions.coerceToObject(pValue, pClass);
    }

    static boolean isNumberClass(Class pClass) {
        return pClass == Byte.class || pClass == Byte.TYPE || pClass == Short.class || pClass == Short.TYPE || pClass == Integer.class || pClass == Integer.TYPE || pClass == Long.class || pClass == Long.TYPE || pClass == Float.class || pClass == Float.TYPE || pClass == Double.class || pClass == Double.TYPE || pClass == BigInteger.class || pClass == BigDecimal.class;
    }

    public static String coerceToString(Object pValue) throws ELException {
        if (pValue == null) {
            return "";
        }
        if (pValue instanceof String) {
            return (String)pValue;
        }
        try {
            return pValue.toString();
        }
        catch (Exception exc) {
            if (log.isErrorEnabled()) {
                String message = _MessageUtil.getMessageWithArgs(_Constants.TOSTRING_EXCEPTION, pValue.getClass().getName());
                log.error((Object)message, (Throwable)exc);
                throw new ELException((Throwable)exc);
            }
            return "";
        }
    }

    public static Number coerceToPrimitiveNumber(Object pValue, Class pClass) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return _Coercions.coerceToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue instanceof Character) {
            char val = ((Character)pValue).charValue();
            return _Coercions.coerceToPrimitiveNumber(new Short((short)val), pClass);
        }
        if (pValue instanceof Boolean) {
            if (log.isErrorEnabled()) {
                String message = _MessageUtil.getMessageWithArgs(_Constants.BOOLEAN_TO_NUMBER, pValue, pClass.getName());
                log.error((Object)message);
                throw new ELException(message);
            }
            return _Coercions.coerceToPrimitiveNumber(ZERO, pClass);
        }
        if (pValue.getClass() == pClass) {
            return (Number)pValue;
        }
        if (pValue instanceof Number) {
            return _Coercions.coerceToPrimitiveNumber((Number)pValue, pClass);
        }
        if (pValue instanceof String) {
            try {
                return _Coercions.coerceToPrimitiveNumber((String)pValue, pClass);
            }
            catch (Exception exc) {
                if (log.isErrorEnabled()) {
                    String message = _MessageUtil.getMessageWithArgs(_Constants.STRING_TO_NUMBER_EXCEPTION, (String)pValue, pClass.getName());
                    log.error((Object)message);
                    throw new ELException(message);
                }
                return _Coercions.coerceToPrimitiveNumber(ZERO, pClass);
            }
        }
        if (log.isErrorEnabled()) {
            String message = _MessageUtil.getMessageWithArgs(_Constants.COERCE_TO_NUMBER, pValue.getClass().getName(), pClass.getName());
            log.error((Object)message);
            throw new ELException(message);
        }
        return _Coercions.coerceToPrimitiveNumber(0L, pClass);
    }

    public static Integer coerceToInteger(Object pValue) throws ELException {
        if (pValue == null) {
            return null;
        }
        if (pValue instanceof Character) {
            return _PrimitiveObjects.getInteger(((Character)pValue).charValue());
        }
        if (pValue instanceof Boolean) {
            if (log.isWarnEnabled()) {
                log.warn((Object)_MessageUtil.getMessageWithArgs(_Constants.BOOLEAN_TO_NUMBER, pValue, Integer.class.getName()));
            }
            return _PrimitiveObjects.getInteger((Boolean)pValue != false ? 1 : 0);
        }
        if (pValue instanceof Integer) {
            return (Integer)pValue;
        }
        if (pValue instanceof Number) {
            return _PrimitiveObjects.getInteger(((Number)pValue).intValue());
        }
        if (pValue instanceof String) {
            try {
                return Integer.valueOf((String)pValue);
            }
            catch (Exception exc) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)_MessageUtil.getMessageWithArgs(_Constants.STRING_TO_NUMBER_EXCEPTION, (String)pValue, Integer.class.getName()));
                }
                return null;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)_MessageUtil.getMessageWithArgs(_Constants.COERCE_TO_NUMBER, pValue.getClass().getName(), Integer.class.getName()));
        }
        return null;
    }

    static Number coerceToPrimitiveNumber(long pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return _PrimitiveObjects.getByte((byte)pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return _PrimitiveObjects.getShort((short)pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return _PrimitiveObjects.getInteger((int)pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return _PrimitiveObjects.getLong(pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return _PrimitiveObjects.getFloat(pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return _PrimitiveObjects.getDouble(pValue);
        }
        return _PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(double pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return _PrimitiveObjects.getByte((byte)pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return _PrimitiveObjects.getShort((short)pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return _PrimitiveObjects.getInteger((int)pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return _PrimitiveObjects.getLong((long)pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return _PrimitiveObjects.getFloat((float)pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return _PrimitiveObjects.getDouble(pValue);
        }
        return _PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(Number pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return _PrimitiveObjects.getByte(pValue.byteValue());
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return _PrimitiveObjects.getShort(pValue.shortValue());
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return _PrimitiveObjects.getInteger(pValue.intValue());
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return _PrimitiveObjects.getLong(pValue.longValue());
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return _PrimitiveObjects.getFloat(pValue.floatValue());
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return _PrimitiveObjects.getDouble(pValue.doubleValue());
        }
        if (pClass == BigInteger.class) {
            if (pValue instanceof BigDecimal) {
                return ((BigDecimal)pValue).toBigInteger();
            }
            return BigInteger.valueOf(pValue.longValue());
        }
        if (pClass == BigDecimal.class) {
            if (pValue instanceof BigInteger) {
                return new BigDecimal((BigInteger)pValue);
            }
            return new BigDecimal(pValue.doubleValue());
        }
        return _PrimitiveObjects.getInteger(0);
    }

    static Number coerceToPrimitiveNumber(String pValue, Class pClass) throws ELException {
        if (pClass == Byte.class || pClass == Byte.TYPE) {
            return Byte.valueOf(pValue);
        }
        if (pClass == Short.class || pClass == Short.TYPE) {
            return Short.valueOf(pValue);
        }
        if (pClass == Integer.class || pClass == Integer.TYPE) {
            return Integer.valueOf(pValue);
        }
        if (pClass == Long.class || pClass == Long.TYPE) {
            return Long.valueOf(pValue);
        }
        if (pClass == Float.class || pClass == Float.TYPE) {
            return Float.valueOf(pValue);
        }
        if (pClass == Double.class || pClass == Double.TYPE) {
            return Double.valueOf(pValue);
        }
        if (pClass == BigInteger.class) {
            return new BigInteger(pValue);
        }
        if (pClass == BigDecimal.class) {
            return new BigDecimal(pValue);
        }
        return _PrimitiveObjects.getInteger(0);
    }

    public static Character coerceToCharacter(Object pValue) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return _PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Character) {
            return (Character)pValue;
        }
        if (pValue instanceof Boolean) {
            if (log.isErrorEnabled()) {
                String message = _MessageUtil.getMessageWithArgs(_Constants.BOOLEAN_TO_CHARACTER, pValue);
                log.error((Object)message);
                throw new ELException(message);
            }
            return _PrimitiveObjects.getCharacter('\u0000');
        }
        if (pValue instanceof Number) {
            return _PrimitiveObjects.getCharacter((char)((Number)pValue).shortValue());
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            return _PrimitiveObjects.getCharacter(str.charAt(0));
        }
        if (log.isErrorEnabled()) {
            String message = _MessageUtil.getMessageWithArgs(_Constants.COERCE_TO_CHARACTER, pValue.getClass().getName());
            log.error((Object)message);
            throw new ELException(message);
        }
        return _PrimitiveObjects.getCharacter('\u0000');
    }

    public static Boolean coerceToBoolean(Object pValue) throws ELException {
        if (pValue == null || "".equals(pValue)) {
            return Boolean.FALSE;
        }
        if (pValue instanceof Boolean) {
            return (Boolean)pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            try {
                return Boolean.valueOf(str);
            }
            catch (Exception exc) {
                if (log.isErrorEnabled()) {
                    String message = _MessageUtil.getMessageWithArgs(_Constants.STRING_TO_BOOLEAN, (String)pValue);
                    log.error((Object)message, (Throwable)exc);
                    throw new ELException(message, (Throwable)exc);
                }
                return Boolean.FALSE;
            }
        }
        if (log.isErrorEnabled()) {
            String message = _MessageUtil.getMessageWithArgs(_Constants.COERCE_TO_BOOLEAN, pValue.getClass().getName());
            log.error((Object)message);
            throw new ELException(message);
        }
        return Boolean.TRUE;
    }

    public static Object coerceToObject(Object pValue, Class pClass) throws ELException {
        if (pValue == null) {
            return null;
        }
        if (pClass.isAssignableFrom(pValue.getClass())) {
            return pValue;
        }
        if (pValue instanceof String) {
            String str = (String)pValue;
            PropertyEditor pe = PropertyEditorManager.findEditor(pClass);
            if (pe == null) {
                if ("".equals(str)) {
                    return null;
                }
                if (log.isErrorEnabled()) {
                    String message = _MessageUtil.getMessageWithArgs(_Constants.NO_PROPERTY_EDITOR, str, pClass.getName());
                    log.error((Object)message);
                    throw new ELException(message);
                }
                return null;
            }
            try {
                pe.setAsText(str);
                return pe.getValue();
            }
            catch (IllegalArgumentException exc) {
                if ("".equals(str)) {
                    return null;
                }
                if (log.isErrorEnabled()) {
                    String message = _MessageUtil.getMessageWithArgs(_Constants.PROPERTY_EDITOR_ERROR, pValue, pClass.getName());
                    log.error((Object)message, (Throwable)exc);
                    throw new ELException(message, (Throwable)exc);
                }
                return null;
            }
        }
        if (log.isErrorEnabled()) {
            String message = _MessageUtil.getMessageWithArgs(_Constants.COERCE_TO_OBJECT, pValue.getClass().getName(), pClass.getName());
            log.error((Object)message);
            throw new ELException(message);
        }
        return null;
    }

    public static boolean isFloatingPointType(Object pObject) {
        return pObject != null && _Coercions.isFloatingPointType(pObject.getClass());
    }

    public static boolean isFloatingPointType(Class pClass) {
        return pClass == Float.class || pClass == Float.TYPE || pClass == Double.class || pClass == Double.TYPE;
    }

    public static boolean isFloatingPointString(Object pObject) {
        if (pObject instanceof String) {
            String str = (String)pObject;
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                if (ch != '.' && ch != 'e' && ch != 'E') continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isIntegerType(Object pObject) {
        return pObject != null && _Coercions.isIntegerType(pObject.getClass());
    }

    public static boolean isIntegerType(Class pClass) {
        return pClass == Byte.class || pClass == Byte.TYPE || pClass == Short.class || pClass == Short.TYPE || pClass == Character.class || pClass == Character.TYPE || pClass == Integer.class || pClass == Integer.TYPE || pClass == Long.class || pClass == Long.TYPE;
    }

    public static boolean isBigInteger(Object pObject) {
        return pObject != null && pObject instanceof BigInteger;
    }

    public static boolean isBigDecimal(Object pObject) {
        return pObject != null && pObject instanceof BigDecimal;
    }
}

