/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.pss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.MyfacesStateManager;
import org.apache.myfaces.application.TreeStructureManager;
import org.apache.myfaces.application.pss.PartialTreeStructureManager;
import org.apache.myfaces.application.pss.TreeStructComponent;
import org.apache.myfaces.application.pss.UIViewRootWrapper;
import org.apache.myfaces.application.pss.ViewHandlerResponseWrapperHelperImpl;
import org.apache.myfaces.context.portlet.PortletExternalContextImpl;
import org.apache.myfaces.context.servlet.ServletExternalContextImpl;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.myfaces.shared_impl.renderkit.ViewSequenceUtils;
import org.apache.myfaces.shared_impl.util.MyFacesObjectInputStream;

public class PssJspStateManagerImpl
extends MyfacesStateManager {
    private static final Log log = LogFactory.getLog((Class)PssJspStateManagerImpl.class);
    private static final String SERIALIZED_VIEW_SESSION_ATTR = PssJspStateManagerImpl.class.getName() + ".SERIALIZED_VIEW";
    private static final String SERIALIZED_VIEW_REQUEST_ATTR = PssJspStateManagerImpl.class.getName() + ".SERIALIZED_VIEW";
    private static final String RESTORED_SERIALIZED_VIEW_REQUEST_ATTR = PssJspStateManagerImpl.class.getName() + ".RESTORED_SERIALIZED_VIEW";
    private static final String PARTIAL_STATE_MANAGER_TREES = PssJspStateManagerImpl.class.getName() + ".PARTIAL_STATE_MANAGER_TREES";
    private static final String NUMBER_OF_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 20;
    private static final String SERIALIZE_STATE_IN_SESSION_PARAM = "org.apache.myfaces.SERIALIZE_STATE_IN_SESSION";
    private static final String COMPRESS_SERVER_STATE_PARAM = "org.apache.myfaces.COMPRESS_STATE_IN_SESSION";
    private static final boolean DEFAULT_COMPRESS_SERVER_STATE_PARAM = true;
    private static final boolean DEFAULT_SERIALIZE_STATE_IN_SESSION = true;
    private static final int UNCOMPRESSED_FLAG = 0;
    private static final int COMPRESSED_FLAG = 1;
    private RenderKitFactory _renderKitFactory = null;
    private static final String PARTIAL_STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.PARTIAL_STATE_SAVING_METHOD";
    private static final String PARTIAL_STATE_SAVING_METHOD_ON = "true";
    private static final String PARTIAL_STATE_SAVING_METHOD_OFF = "false";
    private static final String PARTIAL_STATE_SAVING_DISPATCH_PARAM_NAME = "javax.faces.PARTIAL_STATE_SAVING_DISPATCH_EVERY_TIME";
    private Boolean _partialStateSaving = null;
    private Boolean _partialStateSavingDispatch = null;

    public PssJspStateManagerImpl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New JspStateManagerImpl instance created");
        }
    }

    private boolean isPartialStateSavingOn(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._partialStateSaving != null) {
            return this._partialStateSaving;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(PARTIAL_STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("No context init parameter 'javax.faces.PARTIAL_STATE_SAVING_METHOD' found; no partial state saving method defined, assuming default partial state saving method off.");
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_ON)) {
            this._partialStateSaving = Boolean.TRUE;
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_OFF)) {
            this._partialStateSaving = Boolean.FALSE;
        } else {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("Illegal partial state saving method '" + stateSavingMethod + "', default partial state saving will be used (partial state saving off).");
        }
        return this._partialStateSaving;
    }

    private boolean isPartialStateSavingDispatch(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._partialStateSavingDispatch != null) {
            return this._partialStateSavingDispatch;
        }
        String stateSavingDispatch = context.getExternalContext().getInitParameter(PARTIAL_STATE_SAVING_DISPATCH_PARAM_NAME);
        if (stateSavingDispatch == null) {
            this._partialStateSavingDispatch = Boolean.TRUE;
            context.getExternalContext().log("No context init parameter 'javax.faces.PARTIAL_STATE_SAVING_DISPATCH_EVERY_TIME' found; no partial state saving dispatch usage behavior, assuming default partial state saving dispatch mode on.");
        } else if (stateSavingDispatch.equals(PARTIAL_STATE_SAVING_METHOD_ON)) {
            this._partialStateSavingDispatch = Boolean.TRUE;
        } else if (stateSavingDispatch.equals(PARTIAL_STATE_SAVING_METHOD_OFF)) {
            this._partialStateSavingDispatch = Boolean.FALSE;
        } else {
            this._partialStateSavingDispatch = Boolean.TRUE;
            context.getExternalContext().log("Illegal partial state saving behavior '" + stateSavingDispatch + "', default partial state saving dispatch behavior will be used (dispatch behavior on).");
        }
        return this._partialStateSaving;
    }

    protected Object getComponentStateToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering getComponentStateToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        Object serializedComponentStates = viewRoot.processSaveState(facesContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting getComponentStateToSave");
        }
        return serializedComponentStates;
    }

    protected Object getTreeStructureToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering getTreeStructureToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        TreeStructureManager tsm = new TreeStructureManager();
        Object retVal = tsm.buildTreeStructureToSave(viewRoot);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting getTreeStructureToSave");
        }
        return retVal;
    }

    protected Object getTreeToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering getTreeStructureToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        PartialTreeStructureManager tsm = new PartialTreeStructureManager(facesContext);
        Object retVal = tsm.buildTreeStructureToSave(viewRoot, facesContext);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting getTreeStructureToSave");
        }
        return retVal;
    }

    protected Object restoreViewRoot(FacesContext facesContext, Object storedView) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering getTreeStructureToSave");
        }
        PartialTreeStructureManager tsm = new PartialTreeStructureManager(facesContext);
        UIViewRoot retVal = tsm.restoreTreeStructure(facesContext, storedView);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting getTreeStructureToSave");
        }
        return retVal;
    }

    private String getSequenceString(FacesContext facesContext, String renderKitId, String viewId) {
        RenderKit rk = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
        ResponseStateManager responseStateManager = rk.getResponseStateManager();
        String sequenceStr = (String)responseStateManager.getTreeStructureToRestore(facesContext, viewId);
        return sequenceStr;
    }

    protected UIViewRoot restoreComponentState(FacesContext facesContext, String viewID, String renderKitId) {
        String serializedViewID;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering restoreComponentState");
        }
        UIViewRoot uiViewRoot = null;
        Object serializedComponentStates = null;
        if (this.isSavingStateInClient(facesContext)) {
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            serializedComponentStates = responseStateManager.getComponentStateToRestore(facesContext);
        } else {
            String sequenceStr = this.getSequenceString(facesContext, renderKitId, viewID);
            StateManager.SerializedView serializedView = this.getSerializedViewFromServletSession(facesContext, viewID, sequenceStr);
            if (serializedView != null) {
                serializedComponentStates = serializedView.getStructure();
            }
        }
        Object template = this.LoadTreeFromManager(facesContext, viewID);
        if (serializedComponentStates != null && !(serializedViewID = (String)((Object[])serializedComponentStates)[0]).equals(viewID)) {
            serializedComponentStates = null;
        }
        uiViewRoot = serializedComponentStates != null ? this.mergeComponentData(facesContext, viewID, (TreeStructComponent)((Object[])serializedComponentStates)[1]) : this.mergeComponentData(facesContext, viewID, null);
        Object[] rebuildStateTree = null;
        rebuildStateTree = serializedComponentStates != null ? this.rebuildStateTree((TreeStructComponent)((Object[])serializedComponentStates)[1]) : this.rebuildStateTree((TreeStructComponent)template);
        uiViewRoot.processRestoreState(facesContext, (Object)rebuildStateTree);
        if (uiViewRoot.getRenderKitId() == null) {
            uiViewRoot.setRenderKitId(renderKitId);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting restoreComponentState");
        }
        return uiViewRoot;
    }

    private Object[] rebuildStateTree(TreeStructComponent componentState) {
        HashMap<Object, Object[]> facetMap = null;
        if (componentState.getFacets() != null) {
            for (int iter = 0; iter < componentState.getFacets().length; ++iter) {
                if (facetMap == null) {
                    facetMap = new HashMap<Object, Object[]>();
                }
                TreeStructComponent componentchild = (TreeStructComponent)((Object[])componentState.getFacets()[iter])[1];
                Object componentKey = ((Object[])componentState.getFacets()[iter])[0];
                facetMap.put(componentKey, this.rebuildStateTree(componentchild));
            }
        }
        ArrayList<Object[]> childrenList = null;
        if (componentState.getChildren() != null) {
            TreeStructComponent[] children = componentState.getChildren();
            for (int it = 0; it < children.length; ++it) {
                Object[] childState;
                TreeStructComponent child = children[it];
                if (childrenList == null) {
                    childrenList = new ArrayList<Object[]>(children.length);
                }
                if ((childState = this.rebuildStateTree(child)) == null) continue;
                childrenList.add(childState);
            }
        }
        return new Object[]{componentState.get_componentState(), facetMap, childrenList};
    }

    private void mergeComponent(TreeStructComponent currentComponent, TreeStructComponent templateComponent) {
        TreeStructComponent[] templatechildren = null;
        TreeStructComponent[] currentchildren = currentComponent.getChildren();
        Object[] facets = currentComponent.getFacets();
        if (templateComponent != null) {
            templatechildren = templateComponent.getChildren();
            if (currentComponent.getStatus() == 1) {
                currentComponent.set_componentState(templateComponent.get_componentState());
                currentComponent.setStatus((byte)4);
            }
            if (currentComponent.getStatus() == 3 || currentComponent.getStatus() == 2) {
                currentComponent.setStatus((byte)4);
            }
        } else {
            currentComponent.setStatus((byte)4);
        }
        if (currentchildren != null) {
            int componentIndex;
            HashMap<String, TreeStructComponent> templatechildrenMap = new HashMap<String, TreeStructComponent>();
            if (templatechildren != null) {
                for (componentIndex = 0; componentIndex < templatechildren.length; ++componentIndex) {
                    templatechildrenMap.put(templatechildren[componentIndex].getComponentId(), templatechildren[componentIndex]);
                }
            }
            for (componentIndex = 0; componentIndex < currentchildren.length; ++componentIndex) {
                String id = currentchildren[componentIndex].getComponentId();
                TreeStructComponent foundtemplateComponent = (TreeStructComponent)templatechildrenMap.get(id);
                this.mergeComponent(currentchildren[componentIndex], foundtemplateComponent);
            }
        }
        if (facets != null) {
            HashMap<Object, TreeStructComponent> templatefacetMap = new HashMap<Object, TreeStructComponent>();
            if (templateComponent != null && templateComponent.getFacets() != null) {
                Object[] templatefacets = templateComponent.getFacets();
                for (int componentIndex = 0; componentIndex < templatefacets.length; ++componentIndex) {
                    templatefacetMap.put(((Object[])templatefacets[componentIndex])[0], (TreeStructComponent)((Object[])templatefacets[componentIndex])[1]);
                }
            }
            HashMap<Object, TreeStructComponent> facetMap = new HashMap<Object, TreeStructComponent>();
            for (int iter = 0; iter < facets.length; ++iter) {
                TreeStructComponent facet = (TreeStructComponent)((Object[])facets[iter])[1];
                Object key = ((Object[])facets[iter])[0];
                facetMap.put(key, facet);
            }
            Iterator iter = facetMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                TreeStructComponent foundtemplateComponent = (TreeStructComponent)templatefacetMap.get(entry.getKey());
                this.mergeComponent((TreeStructComponent)entry.getValue(), foundtemplateComponent);
            }
        }
    }

    private UIViewRoot mergeComponentData(FacesContext facesContext, String viewRoot, TreeStructComponent state) {
        TreeStructComponent template = (TreeStructComponent)this.LoadTreeFromManager(facesContext, viewRoot);
        UIViewRoot tempRoot = null;
        if (state == null) {
            tempRoot = (UIViewRoot)this.restoreViewRoot(facesContext, template);
        } else {
            this.mergeComponent(state, template);
            tempRoot = (UIViewRoot)this.restoreViewRoot(facesContext, state);
        }
        return tempRoot;
    }

    protected UIViewRoot restoreTreeStructure(FacesContext facesContext, String viewId, String renderKitId) {
        UIViewRoot uiViewRoot;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering restoreTreeStructure");
        }
        if (!this.isPartialStateSavingOn(facesContext)) {
            log.fatal((Object)"Partial state saving StateManager is installed, but partial state saving is not enabled. Please enable partial state saving or use another StateManager.");
        }
        if (this.isSavingStateInClient(facesContext)) {
            RenderKit rk = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
            ResponseStateManager responseStateManager = rk.getResponseStateManager();
            Object treeStructure = responseStateManager.getTreeStructureToRestore(facesContext, viewId);
            if (treeStructure == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exiting restoreTreeStructure - No tree structure state found in client request");
                }
                return null;
            }
            TreeStructureManager tsm = new TreeStructureManager();
            uiViewRoot = tsm.restoreTreeStructure((TreeStructureManager.TreeStructComponent)treeStructure);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Tree structure restored from client request");
            }
        } else {
            String sequenceStr = this.getSequenceString(facesContext, renderKitId, viewId);
            StateManager.SerializedView serializedView = this.getSerializedViewFromServletSession(facesContext, viewId, sequenceStr);
            if (serializedView == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exiting restoreTreeStructure - No serialized view found in server session!");
                }
                return null;
            }
            Object treeStructure = serializedView.getStructure();
            if (treeStructure == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Exiting restoreTreeStructure - No tree structure state found in server session, former UIViewRoot must have been transient");
                }
                return null;
            }
            TreeStructureManager tsm = new TreeStructureManager();
            uiViewRoot = tsm.restoreTreeStructure((TreeStructureManager.TreeStructComponent)serializedView.getStructure());
            if (log.isTraceEnabled()) {
                log.trace((Object)"Tree structure restored from server session");
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting restoreTreeStructure");
        }
        return uiViewRoot;
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
    }

    public UIViewRoot restoreView(FacesContext facescontext, String viewId, String renderKitId) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering restoreView");
        }
        UIViewRoot uiViewRoot = null;
        Object template = this.LoadTreeFromManager(facescontext, viewId);
        if (template != null) {
            uiViewRoot = this.restoreComponentState(facescontext, viewId, renderKitId);
            uiViewRoot.setViewId(viewId);
            String restoredViewId = uiViewRoot.getViewId();
            if (restoredViewId == null || !restoredViewId.equals(viewId)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Exiting restoreView - restored view is null.");
                }
                return null;
            }
            if (this.isPartialStateSavingDispatch(facescontext)) {
                this.dispatchJSP(facescontext, viewId);
            }
        } else {
            this.dispatchJSP(facescontext, viewId);
            this.SaveTreeInManager(facescontext);
            uiViewRoot = this.restoreComponentState(facescontext, viewId, renderKitId);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting restoreView");
        }
        return uiViewRoot;
    }

    private void dispatchJSP(FacesContext facescontext, String viewId) {
        Application application = facescontext.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        ExternalContext externalContext = facescontext.getExternalContext();
        UIViewRoot uiViewRoot = applicationViewHandler.createView(facescontext, viewId);
        uiViewRoot.setViewId(viewId);
        UIViewRootWrapper currentWrapper = new UIViewRootWrapper(uiViewRoot);
        facescontext.setViewRoot((UIViewRoot)currentWrapper);
        Object orgResponse = facescontext.getExternalContext().getResponse();
        ViewHandlerResponseWrapperHelperImpl wrapped = new ViewHandlerResponseWrapperHelperImpl((HttpServletResponse)facescontext.getExternalContext().getResponse());
        if (externalContext instanceof ServletExternalContextImpl || externalContext instanceof PortletExternalContextImpl) {
            try {
                BeanUtils.setProperty((Object)externalContext, (String)"response", (Object)((Object)wrapped));
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.toString());
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.toString());
            }
        } else {
            log.error((Object)"External Response could not be set! Deaktivate Partial State Saving!");
        }
        try {
            externalContext.dispatch(viewId);
        }
        catch (IOException e) {
            log.error((Object)e.toString());
        }
        if (externalContext instanceof ServletExternalContextImpl || externalContext instanceof PortletExternalContextImpl) {
            try {
                BeanUtils.setProperty((Object)externalContext, (String)"response", (Object)orgResponse);
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.toString());
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.toString());
            }
        } else {
            log.error((Object)"External Response could not be set! Deaktivate Partial State Saving!");
        }
        int beforeViewLength = 0;
        UIComponent beforeview = (UIComponent)facescontext.getViewRoot().getChildren().get(0);
        if (beforeview instanceof UIOutput) {
            beforeViewLength = ((String)((UIOutput)beforeview).getValue()).length();
        } else {
            log.error((Object)"No before view element found!");
        }
        String beforeViewContent = wrapped.toString().substring(beforeViewLength);
        facescontext.getViewRoot().getChildren().add(facescontext.getViewRoot().getChildCount(), this.createUIOutputComponentFromString(facescontext, beforeViewContent));
        wrapped.resetWriter();
    }

    protected UIComponent createUIOutputComponentFromString(FacesContext context, String content) {
        UIOutput verbatim = null;
        verbatim = this.createUIOutputComponent(context);
        verbatim.setValue((Object)content);
        return verbatim;
    }

    protected UIOutput createUIOutputComponent(FacesContext context) {
        if (context == null) {
            return null;
        }
        UIOutput verbatim = null;
        Application application = context.getApplication();
        verbatim = (UIOutput)application.createComponent("javax.faces.HtmlOutputText");
        verbatim.setTransient(true);
        verbatim.getAttributes().put("escape", Boolean.FALSE);
        verbatim.setId(context.getViewRoot().createUniqueId());
        return verbatim;
    }

    public void SaveTreeInManager(FacesContext facesContext) throws IllegalStateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering saveSerializedView");
        }
        PssJspStateManagerImpl.checkForDuplicateIds(facesContext, (UIComponent)facesContext.getViewRoot(), new HashSet());
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing saveSerializedView - Checked for duplicate Ids");
        }
        Object Tree = this.getTreeToSave(facesContext);
        Map appmap = facesContext.getExternalContext().getApplicationMap();
        HashMap<String, Object> mymap = (HashMap<String, Object>)appmap.get(PARTIAL_STATE_MANAGER_TREES);
        if (mymap == null) {
            mymap = new HashMap<String, Object>();
        }
        mymap.put(facesContext.getViewRoot().getViewId(), Tree);
        appmap.put(PARTIAL_STATE_MANAGER_TREES, mymap);
    }

    public Object LoadUIViewRootFromManager(FacesContext facesContext, String viewID) throws IllegalStateException {
        Object tree = this.LoadTreeFromManager(facesContext, viewID);
        if (tree != null) {
            return this.restoreViewRoot(facesContext, tree);
        }
        return null;
    }

    public Object LoadTreeFromManager(FacesContext facesContext, String viewID) throws IllegalStateException {
        Map appmap = facesContext.getExternalContext().getApplicationMap();
        HashMap mymap = (HashMap)appmap.get(PARTIAL_STATE_MANAGER_TREES);
        if (mymap != null) {
            Object test = mymap.get(viewID);
            return test;
        }
        return null;
    }

    public StateManager.SerializedView saveSerializedView(FacesContext facesContext) throws IllegalStateException {
        StateManager.SerializedView serializedView;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering saveSerializedView");
        }
        PssJspStateManagerImpl.checkForDuplicateIds(facesContext, (UIComponent)facesContext.getViewRoot(), new HashSet());
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing saveSerializedView - Checked for duplicate Ids");
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        TreeStructComponent templateRoot = (TreeStructComponent)this.LoadTreeFromManager(facesContext, facesContext.getViewRoot().getViewId());
        TreeStructComponent diff = null;
        if (templateRoot != null) {
            diff = this.diffAgainsTemplate(facesContext, templateRoot);
        }
        if ((serializedView = (StateManager.SerializedView)externalContext.getRequestMap().get(SERIALIZED_VIEW_REQUEST_ATTR)) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing saveSerializedView - create new serialized view");
            }
            serializedView = new StateManager.SerializedView((StateManager)this, null, (Object)new Object[]{facesContext.getViewRoot().getViewId(), diff});
            externalContext.getRequestMap().put(SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing saveSerializedView - new serialized view created");
            }
        }
        if (!this.isSavingStateInClient(facesContext)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing saveSerializedView - server-side state saving - save state");
            }
            this.saveSerializedViewInServletSession(facesContext, serializedView);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exiting saveSerializedView - server-side state saving - saved state");
            }
            Integer sequence = ViewSequenceUtils.getViewSequence(facesContext);
            return new StateManager.SerializedView((StateManager)this, (Object)sequence.toString(), null);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting saveSerializedView - client-side state saving");
        }
        return serializedView;
    }

    private boolean difState(Object[] currentState, Object[] templateState) {
        boolean isEqual = true;
        for (int index = 0; index < currentState.length; ++index) {
            if (templateState[index] == null && currentState[index] != null) {
                isEqual = false;
                continue;
            }
            if (currentState[index] instanceof Object[]) {
                if (this.difState((Object[])currentState[index], (Object[])templateState[index])) continue;
                isEqual = false;
                continue;
            }
            if (currentState[index] == null || currentState[index].equals(templateState[index])) continue;
            isEqual = false;
        }
        return isEqual;
    }

    private TreeStructComponent diffComponent(TreeStructComponent currentComponent, TreeStructComponent templateComponent) {
        TreeStructComponent diffComponent = currentComponent.clone(templateComponent);
        boolean isEqual = false;
        Object[] templateComponentState = null;
        TreeStructComponent[] templatechildren = null;
        Object[] currentComponentState = (Object[])currentComponent.get_componentState();
        TreeStructComponent[] currentchildren = currentComponent.getChildren();
        if (templateComponent != null) {
            templateComponentState = (Object[])templateComponent.get_componentState();
            templatechildren = templateComponent.getChildren();
            if (currentComponentState.length == templateComponentState.length) {
                isEqual = this.difState(currentComponentState, templateComponentState);
            }
        } else {
            isEqual = false;
        }
        if (!isEqual) {
            diffComponent.set_componentState(currentComponent.get_componentState());
            diffComponent.setStatus((byte)2);
        } else {
            diffComponent.setStatus((byte)1);
            diffComponent.set_componentState(null);
        }
        if (currentchildren != null) {
            HashMap<String, TreeStructComponent> templatechildrenMap = new HashMap<String, TreeStructComponent>();
            if (templatechildren != null) {
                for (int componentIndex = 0; componentIndex < templatechildren.length; ++componentIndex) {
                    templatechildrenMap.put(templatechildren[componentIndex].getComponentId(), templatechildren[componentIndex]);
                }
            }
            ArrayList<TreeStructComponent> childs = new ArrayList<TreeStructComponent>();
            for (int componentIndex = 0; componentIndex < currentchildren.length; ++componentIndex) {
                if (currentchildren[componentIndex].isTransient()) continue;
                String id = currentchildren[componentIndex].getComponentId();
                TreeStructComponent foundtemplateComponent = (TreeStructComponent)templatechildrenMap.get(id);
                childs.add(this.diffComponent(currentchildren[componentIndex], foundtemplateComponent));
            }
            childs.toArray(new TreeStructComponent[childs.size()]);
            diffComponent.setChildren(childs.toArray(new TreeStructComponent[childs.size()]));
        }
        if (currentComponent.getFacets() != null) {
            ArrayList<Object[]> facets = new ArrayList<Object[]>();
            HashMap<Object, TreeStructComponent> templatefacetMap = new HashMap<Object, TreeStructComponent>();
            if (templateComponent != null && templateComponent.getFacets() != null) {
                Object[] templatefacets = templateComponent.getFacets();
                for (int componentIndex = 0; componentIndex < templatefacets.length; ++componentIndex) {
                    templatefacetMap.put(((Object[])templatefacets[componentIndex])[0], (TreeStructComponent)((Object[])templatefacets[componentIndex])[1]);
                }
            }
            HashMap<Object, TreeStructComponent> facetMap = new HashMap<Object, TreeStructComponent>();
            if (currentComponent != null && currentComponent.getFacets() != null) {
                Object[] currentfacets = currentComponent.getFacets();
                for (int componentIndex = 0; componentIndex < currentfacets.length; ++componentIndex) {
                    facetMap.put(((Object[])currentfacets[componentIndex])[0], (TreeStructComponent)((Object[])currentfacets[componentIndex])[1]);
                }
            }
            Iterator iter = facetMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (((TreeStructComponent)entry.getValue()).isTransient()) continue;
                TreeStructComponent foundtemplateComponent = (TreeStructComponent)templatefacetMap.get(entry.getKey());
                Object[] objectEntry = new Object[]{entry.getKey(), this.diffComponent((TreeStructComponent)entry.getValue(), foundtemplateComponent)};
                facets.add(objectEntry);
            }
            diffComponent.setFacets(facets.toArray());
        }
        return diffComponent;
    }

    private TreeStructComponent diffAgainsTemplate(FacesContext facesContext, TreeStructComponent templateRoot) {
        TreeStructComponent currentTree = (TreeStructComponent)this.getTreeToSave(facesContext);
        TreeStructComponent dif = this.diffComponent(currentTree, templateRoot);
        return dif;
    }

    private static void checkForDuplicateIds(FacesContext context, UIComponent component, Set ids) {
        String id = component.getId();
        if (id != null && !ids.add(id)) {
            throw new IllegalStateException("Client-id : " + id + " is duplicated in the faces tree. Component : " + component.getClientId(context) + ", path: " + PssJspStateManagerImpl.getPathToComponent(component));
        }
        Iterator it = component.getFacetsAndChildren();
        boolean namingContainer = component instanceof NamingContainer;
        while (it.hasNext()) {
            UIComponent kid = (UIComponent)it.next();
            if (namingContainer) {
                PssJspStateManagerImpl.checkForDuplicateIds(context, kid, new HashSet());
                continue;
            }
            PssJspStateManagerImpl.checkForDuplicateIds(context, kid, ids);
        }
    }

    private static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        PssJspStateManagerImpl.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        if (component != null) {
            PssJspStateManagerImpl.getPathToComponent(component.getParent(), buf);
        }
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering writeState");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing writeState - either client-side (full state) or server-side (partial information; e.g. sequence)");
        }
        if (serializedView != null) {
            UIViewRoot uiViewRoot = facesContext.getViewRoot();
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, uiViewRoot.getRenderKitId());
            renderKit.getResponseStateManager().writeState(facesContext, serializedView);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exiting writeState");
            }
        }
    }

    public void writeStateAsUrlParams(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering writeStateAsUrlParams");
        }
        if (this.isSavingStateInClient(facesContext)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing writeStateAsUrlParams - client-side state saving writing state");
            }
            UIViewRoot uiViewRoot = facesContext.getViewRoot();
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, uiViewRoot.getRenderKitId());
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            if (responseStateManager instanceof MyfacesResponseStateManager) {
                ((MyfacesResponseStateManager)responseStateManager).writeStateAsUrlParams(facesContext, serializedView);
            } else {
                log.error((Object)("ResponseStateManager of render kit " + uiViewRoot.getRenderKitId() + " is no MyfacesResponseStateManager and does not support saving state in url parameters."));
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting writeStateAsUrlParams");
        }
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    protected void saveSerializedViewInServletSession(FacesContext context, StateManager.SerializedView serializedView) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        SerializedViewCollection viewCollection = (SerializedViewCollection)sessionMap.get(SERIALIZED_VIEW_SESSION_ATTR);
        if (viewCollection == null) {
            viewCollection = new SerializedViewCollection();
            sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
        }
        viewCollection.add(context, this.serializeView(context, serializedView));
        sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
    }

    protected StateManager.SerializedView getSerializedViewFromServletSession(FacesContext context, String viewId, String sequenceStr) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        StateManager.SerializedView serializedView = null;
        if (requestMap.containsKey(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR)) {
            serializedView = (StateManager.SerializedView)requestMap.get(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR);
        } else {
            SerializedViewCollection viewCollection = (SerializedViewCollection)externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR);
            if (viewCollection != null) {
                Object state;
                Integer sequence = null;
                sequence = sequenceStr == null ? ViewSequenceUtils.getCurrentSequence(context) : new Integer(sequenceStr);
                if (sequence != null && (state = viewCollection.get(sequence, viewId)) != null) {
                    serializedView = this.deserializeView(state);
                }
            }
            requestMap.put(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            ViewSequenceUtils.nextViewSequence(context);
        }
        return serializedView;
    }

    protected Object serializeView(FacesContext context, StateManager.SerializedView serializedView) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering serializeView");
        }
        if (this.isSerializeStateInSession(context)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Processing serializeView - serialize state in session");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                OutputStream os = baos;
                if (this.isCompressStateInSession(context)) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Processing serializeView - serialize compressed");
                    }
                    ((OutputStream)os).write(1);
                    os = new GZIPOutputStream(os, 1024);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Processing serializeView - serialize uncompressed");
                    }
                    ((OutputStream)os).write(0);
                }
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(serializedView.getStructure());
                out.writeObject(serializedView.getState());
                out.close();
                baos.close();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Exiting serializeView - serialized. Bytes : " + baos.size()));
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                log.error((Object)("Exiting serializeView - Could not serialize state: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Exiting serializeView - do not serialize state in session.");
        }
        return new Object[]{serializedView.getStructure(), serializedView.getState()};
    }

    protected boolean isSerializeStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(SERIALIZE_STATE_IN_SESSION_PARAM);
        boolean serialize = true;
        if (value != null) {
            serialize = new Boolean(value);
        }
        return serialize;
    }

    protected boolean isCompressStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(COMPRESS_SERVER_STATE_PARAM);
        boolean compress = true;
        if (value != null) {
            compress = new Boolean(value);
        }
        return compress;
    }

    protected StateManager.SerializedView deserializeView(Object state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Entering deserializeView");
        }
        if (state instanceof byte[]) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Processing deserializeView - deserializing serialized state. Bytes : " + ((byte[])state).length));
            }
            try {
                ByteArrayInputStream bais;
                InputStream is = bais = new ByteArrayInputStream((byte[])state);
                if (((InputStream)is).read() == 1) {
                    is = new GZIPInputStream(is);
                }
                MyFacesObjectInputStream in = new MyFacesObjectInputStream(is);
                Object a = in.readObject();
                Object b = in.readObject();
                return new StateManager.SerializedView((StateManager)this, a, b);
            }
            catch (IOException e) {
                log.error((Object)("Exiting deserializeView - Could not deserialize state: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Exiting deserializeView - Could not deserialize state: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        if (state instanceof Object[]) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Exiting deserializeView - state not serialized.");
            }
            Object[] value = (Object[])state;
            return new StateManager.SerializedView((StateManager)this, value[0], value[1]);
        }
        if (state == null) {
            log.error((Object)"Exiting deserializeView - this method should not be called with a null-state.");
            return null;
        }
        log.error((Object)("Exiting deserializeView - this method should not be called with a state of type : " + state.getClass()));
        return null;
    }

    protected static class SerializedViewKey
    implements Serializable {
        private static final long serialVersionUID = -1170697124386063642L;
        private final String _viewId;
        private final Integer _sequenceId;

        public SerializedViewKey(String viewId, Integer sequence) {
            this._sequenceId = sequence;
            this._viewId = viewId;
        }

        public SerializedViewKey(FacesContext context) {
            this._sequenceId = ViewSequenceUtils.getViewSequence(context);
            this._viewId = context.getViewRoot().getViewId();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof SerializedViewKey) {
                SerializedViewKey other = (SerializedViewKey)obj;
                return new EqualsBuilder().append((Object)other._viewId, (Object)this._viewId).append((Object)other._sequenceId, (Object)this._sequenceId).isEquals();
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this._viewId).append((Object)this._sequenceId).toHashCode();
        }
    }

    protected static class SerializedViewCollection
    implements Serializable {
        private static final long serialVersionUID = -3734849062185115847L;
        private final List _keys = new ArrayList(20);
        private final Map _serializedViews = new HashMap();
        private transient Map _oldSerializedViews = null;

        protected SerializedViewCollection() {
        }

        public synchronized void add(FacesContext context, Object state) {
            SerializedViewKey key = new SerializedViewKey(context);
            this._serializedViews.put(key, state);
            while (this._keys.remove(key)) {
            }
            this._keys.add(key);
            int views = this.getNumberOfViewsInSession(context);
            while (this._keys.size() > views) {
                key = this._keys.remove(0);
                Object oldView = this._serializedViews.remove(key);
                if (oldView == null) continue;
                this.getOldSerializedViewsMap().put(key, oldView);
            }
        }

        protected int getNumberOfViewsInSession(FacesContext context) {
            String value = context.getExternalContext().getInitParameter(PssJspStateManagerImpl.NUMBER_OF_VIEWS_IN_SESSION_PARAM);
            int views = 20;
            if (value != null) {
                try {
                    views = Integer.parseInt(value);
                    if (views <= 0) {
                        log.error((Object)"Configured value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION is not valid, must be an value > 0, using default value (20");
                        views = 20;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Error determining the value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION, expected an integer value > 0, using default value (20): " + e.getMessage()), e);
                }
            }
            return views;
        }

        protected Map getOldSerializedViewsMap() {
            if (this._oldSerializedViews == null) {
                this._oldSerializedViews = new ReferenceMap();
            }
            return this._oldSerializedViews;
        }

        public Object get(Integer sequence, String viewId) {
            SerializedViewKey key = new SerializedViewKey(viewId, sequence);
            Object value = this._serializedViews.get(key);
            if (value == null) {
                value = this.getOldSerializedViewsMap().get(key);
            }
            return value;
        }
    }
}

