/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.io.PrintStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.api.MonotonicClock;
import org.apache.maven.slf4j.SimpleLoggerConfiguration;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.event.LoggingEvent;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.helpers.NormalizedParameters;

public class MavenBaseLogger
extends LegacyAbstractLogger {
    protected static final int LOG_LEVEL_TRACE = 0;
    protected static final int LOG_LEVEL_DEBUG = 10;
    protected static final int LOG_LEVEL_INFO = 20;
    protected static final int LOG_LEVEL_WARN = 30;
    protected static final int LOG_LEVEL_ERROR = 40;
    static final char SP = ' ';
    static final String TID_PREFIX = "tid=";
    protected static final int LOG_LEVEL_OFF = 50;
    static final SimpleLoggerConfiguration CONFIG_PARAMS = new SimpleLoggerConfiguration();
    static boolean initialized = false;
    protected int currentLogLevel = 20;
    private transient String shortLogName = null;
    public static final String LEGACY_PREFIX = "org.slf4j.simpleLogger.";

    static void lazyInit() {
        if (initialized) {
            return;
        }
        initialized = true;
        MavenBaseLogger.init();
    }

    static void init() {
        CONFIG_PARAMS.init();
    }

    protected MavenBaseLogger(String name) {
        this.name = name;
        String levelString = this.recursivelyComputeLevelString();
        this.currentLogLevel = levelString != null ? SimpleLoggerConfiguration.stringToLevel(levelString) : MavenBaseLogger.CONFIG_PARAMS.defaultLogLevel;
    }

    String recursivelyComputeLevelString() {
        String tempName = this.name;
        String levelString = null;
        int indexOfLastDot = tempName.length();
        while (levelString == null && indexOfLastDot > -1) {
            tempName = tempName.substring(0, indexOfLastDot);
            levelString = CONFIG_PARAMS.getStringProperty("maven.logger.log." + tempName, null);
            indexOfLastDot = tempName.lastIndexOf(".");
        }
        return levelString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(StringBuilder buf, Throwable t) {
        PrintStream targetStream = MavenBaseLogger.CONFIG_PARAMS.outputChoice.getTargetPrintStream();
        SimpleLoggerConfiguration simpleLoggerConfiguration = CONFIG_PARAMS;
        synchronized (simpleLoggerConfiguration) {
            targetStream.println(buf.toString());
            this.writeThrowable(t, targetStream);
            targetStream.flush();
        }
    }

    protected void writeThrowable(Throwable t, PrintStream targetStream) {
        if (t != null) {
            t.printStackTrace(targetStream);
        }
    }

    protected String computeShortName() {
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(10);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(20);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(30);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(40);
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
        ArrayList<Marker> markers = null;
        if (marker != null) {
            markers = new ArrayList<Marker>();
            markers.add(marker);
        }
        this.innerHandleNormalizedLoggingCall(level, markers, messagePattern, arguments, throwable);
    }

    private void innerHandleNormalizedLoggingCall(Level level, List<Marker> markers, String messagePattern, Object[] arguments, Throwable t) {
        StringBuilder buf = new StringBuilder(32);
        if (MavenBaseLogger.CONFIG_PARAMS.showDateTime) {
            DateTimeFormatter formatter = MavenBaseLogger.CONFIG_PARAMS.dateFormatter;
            if (formatter != null) {
                ZonedDateTime zonedDateTime = MonotonicClock.now().atZone(ZoneId.systemDefault());
                String dateText = formatter.format(zonedDateTime);
                buf.append(dateText);
                buf.append(' ');
            } else {
                buf.append(MonotonicClock.elapsed().toMillis());
                buf.append(' ');
            }
        }
        if (MavenBaseLogger.CONFIG_PARAMS.showThreadName) {
            buf.append('[');
            buf.append(Thread.currentThread().getName());
            buf.append("] ");
        }
        if (MavenBaseLogger.CONFIG_PARAMS.showThreadId) {
            buf.append(TID_PREFIX);
            buf.append(Thread.currentThread().getId());
            buf.append(' ');
        }
        if (MavenBaseLogger.CONFIG_PARAMS.levelInBrackets) {
            buf.append('[');
        }
        String levelStr = this.renderLevel(level.toInt());
        buf.append(levelStr);
        if (MavenBaseLogger.CONFIG_PARAMS.levelInBrackets) {
            buf.append(']');
        }
        buf.append(' ');
        if (MavenBaseLogger.CONFIG_PARAMS.showShortLogName) {
            if (this.shortLogName == null) {
                this.shortLogName = this.computeShortName();
            }
            buf.append(this.shortLogName).append(" - ");
        } else if (MavenBaseLogger.CONFIG_PARAMS.showLogName) {
            buf.append(this.name).append(" - ");
        }
        if (markers != null) {
            buf.append(' ');
            for (Marker marker : markers) {
                buf.append(marker.getName()).append(' ');
            }
        }
        String formattedMessage = MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments);
        buf.append(formattedMessage);
        this.write(buf, t);
    }

    protected String renderLevel(int levelInt) {
        return switch (levelInt) {
            case 0 -> "TRACE";
            case 10 -> "DEBUG";
            case 20 -> "INFO";
            case 30 -> "WARN";
            case 40 -> "ERROR";
            default -> throw new IllegalStateException("Unrecognized level [" + levelInt + "]");
        };
    }

    public void log(LoggingEvent event) {
        int levelInt = event.getLevel().toInt();
        if (!this.isLevelEnabled(levelInt)) {
            return;
        }
        NormalizedParameters np = NormalizedParameters.normalize((LoggingEvent)event);
        this.innerHandleNormalizedLoggingCall(event.getLevel(), event.getMarkers(), np.getMessage(), np.getArguments(), event.getThrowable());
    }

    protected String getFullyQualifiedCallerName() {
        return null;
    }
}

