/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeUtils {
    private static final int ONE_UNIT = 1;
    public static final long DAYS_MILLIS = TimeUnit.DAYS.toMillis(1L);
    public static final long HOURS_MILLIS = TimeUnit.HOURS.toMillis(1L);
    public static final long MINUTES_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    public static final long SECONDS_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final Pattern DURATION_PATTERN = Pattern.compile("(?<n>-?\\d+)|(((?<d>\\d+)\\s*d(ay(s)?)?)?\\s*((?<h>\\d+)\\s*h(our(s)?)?)?\\s*((?<m>\\d+)\\s*m(in(ute(s)?)?)?)?\\s*((?<s>\\d+(\\.\\d+)?)\\s*s(ec(ond(s)?)?)?)?\\s*((?<l>\\d+(\\.\\d+)?)\\s*m(illi)?s(ec(ond)?(s)?)?)?)", 2);

    private TimeUtils() {
    }

    public static boolean isPositive(Duration dur) {
        return dur.getSeconds() > 0L || dur.getNano() != 0;
    }

    public static String printDuration(Duration uptime) {
        return TimeUtils.printDuration(uptime.toMillis());
    }

    public static String printDuration(long millis) {
        if (millis < 0L) {
            return Long.toString(millis);
        }
        StringBuilder sb = new StringBuilder();
        if (millis >= DAYS_MILLIS) {
            sb.append(millis / DAYS_MILLIS).append("d");
            millis %= DAYS_MILLIS;
        }
        if (millis >= HOURS_MILLIS) {
            sb.append(millis / HOURS_MILLIS).append("h");
            millis %= HOURS_MILLIS;
        }
        if (millis >= MINUTES_MILLIS) {
            sb.append(millis / MINUTES_MILLIS).append("m");
            millis %= MINUTES_MILLIS;
        }
        if (millis >= SECONDS_MILLIS) {
            sb.append(millis / SECONDS_MILLIS).append("s");
            millis %= SECONDS_MILLIS;
        }
        if (millis >= 1L || sb.length() == 0) {
            sb.append(millis / 1L).append("ms");
        }
        return sb.toString();
    }

    public static Duration toDuration(String source) throws IllegalArgumentException {
        return Duration.ofMillis(TimeUtils.toMilliSeconds(source));
    }

    public static long toMilliSeconds(String source) throws IllegalArgumentException {
        Matcher matcher = DURATION_PATTERN.matcher(source);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unable to parse duration: '" + source + "'");
        }
        String n = matcher.group("n");
        if (n != null) {
            return Long.parseLong(n);
        }
        String d = matcher.group("d");
        String h = matcher.group("h");
        String m = matcher.group("m");
        String s = matcher.group("s");
        String l = matcher.group("l");
        return (d != null ? TimeUnit.DAYS.toMillis(Long.parseLong(d)) : 0L) + (h != null ? TimeUnit.HOURS.toMillis(Long.parseLong(h)) : 0L) + (m != null ? TimeUnit.MINUTES.toMillis(Long.parseLong(m)) : 0L) + (s != null ? TimeUnit.SECONDS.toMillis(Long.parseLong(s)) : 0L) + (l != null ? TimeUnit.MILLISECONDS.toMillis(Long.parseLong(l)) : 0L);
    }
}

