/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.Stream;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.common.TimeUtils;

public enum OptionType {
    BOOLEAN,
    DURATION{

        @Override
        public String normalize(String value) {
            return TimeUtils.printDuration(TimeUtils.toMilliSeconds(value));
        }
    }
    ,
    INTEGER,
    MEMORY_SIZE,
    PATH,
    STRING,
    VOID;


    public String normalize(String value) {
        return value;
    }

    public static Stream<Environment.DocumentedEnumEntry<OptionType>> documentedEntries() {
        Properties props = new Properties();
        OptionType[] values = OptionType.values();
        String cliOptionsPath = ((Object)((Object)values[0])).getClass().getSimpleName() + ".javadoc.properties";
        try (InputStream in = Environment.class.getResourceAsStream(cliOptionsPath);){
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read " + cliOptionsPath, e);
        }
        return Stream.of(values).filter(opt -> opt != VOID).sorted(Comparator.comparing(Enum::name)).map(env -> new Environment.DocumentedEnumEntry<OptionType>((OptionType)((Object)env), props.getProperty(env.name())));
    }
}

