/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnenc.goals;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.cling.invoker.mvnenc.EncryptContext;
import org.apache.maven.cling.invoker.mvnenc.goals.InteractiveGoalSupport;
import org.codehaus.plexus.components.secdispatcher.DispatcherMeta;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.model.Config;
import org.codehaus.plexus.components.secdispatcher.model.ConfigProperty;
import org.codehaus.plexus.components.secdispatcher.model.SettingsSecurity;
import org.jline.consoleui.elements.ConfirmChoice;
import org.jline.consoleui.prompt.ConfirmResult;
import org.jline.consoleui.prompt.ConsolePrompt;
import org.jline.consoleui.prompt.PromptResultItemIF;
import org.jline.consoleui.prompt.builder.ListPromptBuilder;
import org.jline.consoleui.prompt.builder.PromptBuilder;
import org.jline.utils.Colors;
import org.jline.utils.OSUtils;

@Singleton
@Named(value="init")
public class Init
extends InteractiveGoalSupport {
    private static final String NONE = "__none__";

    @Inject
    public Init(MessageBuilderFactory messageBuilderFactory, SecDispatcher secDispatcher) {
        super(messageBuilderFactory, secDispatcher);
    }

    @Override
    public int doExecute(EncryptContext context) throws Exception {
        boolean force = context.options().force().orElse(false);
        boolean yes = context.options().yes().orElse(false);
        if (this.configExists() && !force) {
            context.logger.error(this.messageBuilderFactory.builder().error((Object)"Error: configuration exist. Use --force if you want to reset existing configuration.").build());
            return 2;
        }
        context.addInHeader(context.style.italic().bold().foreground(Colors.rgbColor((String)"yellow").intValue()), "goal: init");
        context.addInHeader("");
        ConsolePrompt.UiConfig promptConfig = OSUtils.IS_WINDOWS ? new ConsolePrompt.UiConfig(">", "( )", "(x)", "( )") : new ConsolePrompt.UiConfig("\u276f", "\u25ef ", "\u25c9 ", "\u25ef ");
        promptConfig.setCancellableFirstPrompt(true);
        SettingsSecurity config = this.secDispatcher.readConfiguration(true);
        config.setDefaultDispatcher(null);
        config.getConfigurations().clear();
        ConsolePrompt prompt = new ConsolePrompt(context.reader, context.terminal, promptConfig);
        Map dispatcherResult = prompt.prompt(context.header, this.dispatcherPrompt(prompt.getPromptBuilder()).build());
        if (dispatcherResult.isEmpty()) {
            throw new InterruptedException();
        }
        if (NONE.equals(((PromptResultItemIF)dispatcherResult.get("defaultDispatcher")).getResult())) {
            context.terminal.writer().println(this.messageBuilderFactory.builder().warning((Object)"Maven4 SecDispatcher disabled; Maven3 fallback may still work, use `mvnenc diag` to check").build());
        } else {
            config.setDefaultDispatcher(((PromptResultItemIF)dispatcherResult.get("defaultDispatcher")).getResult());
            DispatcherMeta meta = this.secDispatcher.availableDispatchers().stream().filter(d -> Objects.equals(config.getDefaultDispatcher(), d.name())).findFirst().orElseThrow();
            if (!meta.fields().isEmpty()) {
                Map dispatcherConfigResult = prompt.prompt(context.header, this.configureDispatcher(context, meta, prompt.getPromptBuilder()).build());
                if (dispatcherConfigResult.isEmpty()) {
                    throw new InterruptedException();
                }
                List<Map.Entry> editables = dispatcherConfigResult.entrySet().stream().filter(e -> ((PromptResultItemIF)e.getValue()).getResult().contains("$")).toList();
                if (!editables.isEmpty()) {
                    context.addInHeader("");
                    context.addInHeader("Please customize the editable value:");
                    for (Map.Entry entry : editables) {
                        String template = ((PromptResultItemIF)entry.getValue()).getResult();
                        Map editMap = prompt.prompt(context.header, prompt.getPromptBuilder().createInputPrompt().name("edit").message(template).addPrompt().build());
                        if (editMap.isEmpty()) {
                            throw new InterruptedException();
                        }
                        dispatcherConfigResult.put((String)entry.getKey(), (PromptResultItemIF)editMap.get("edit"));
                    }
                }
                Config dispatcherConfig = new Config();
                dispatcherConfig.setName(meta.name());
                for (DispatcherMeta.Field field : meta.fields()) {
                    ConfigProperty property = new ConfigProperty();
                    property.setName(field.getKey());
                    property.setValue(((PromptResultItemIF)dispatcherConfigResult.get(field.getKey())).getResult());
                    dispatcherConfig.addProperty(property);
                }
                if (!dispatcherConfig.getProperties().isEmpty()) {
                    config.addConfiguration(dispatcherConfig);
                }
            }
        }
        if (yes) {
            this.secDispatcher.writeConfiguration(config);
        } else {
            context.addInHeader("");
            context.addInHeader("Values set:");
            context.addInHeader("defaultDispatcher=" + config.getDefaultDispatcher());
            for (Config c : config.getConfigurations()) {
                context.addInHeader("  dispatcherName=" + c.getName());
                for (ConfigProperty cp : c.getProperties()) {
                    context.addInHeader("    " + cp.getName() + "=" + cp.getValue());
                }
            }
            Map confirmChoice = prompt.prompt(context.header, this.confirmPrompt(prompt.getPromptBuilder()).build());
            ConfirmResult confirm = (ConfirmResult)confirmChoice.get("confirm");
            if (confirm.getConfirmed() == ConfirmChoice.ConfirmationValue.YES) {
                context.terminal.writer().println(this.messageBuilderFactory.builder().info((Object)"Writing out the configuration...").build());
                this.secDispatcher.writeConfiguration(config);
            } else {
                context.terminal.writer().println(this.messageBuilderFactory.builder().warning((Object)"Values not accepted; not saving configuration.").build());
                return 3;
            }
        }
        return 0;
    }

    protected PromptBuilder confirmPrompt(PromptBuilder promptBuilder) {
        promptBuilder.createConfirmPromp().name("confirm").message("Are values above correct?").defaultValue(ConfirmChoice.ConfirmationValue.YES).addPrompt();
        return promptBuilder;
    }

    protected PromptBuilder dispatcherPrompt(PromptBuilder promptBuilder) {
        ListPromptBuilder listPromptBuilder = promptBuilder.createListPrompt().name("defaultDispatcher").message("Which dispatcher you want to use as default?");
        listPromptBuilder.newItem().name(NONE).text("None (disable MavenSecDispatcher)").add();
        for (DispatcherMeta meta : this.secDispatcher.availableDispatchers()) {
            if (meta.isHidden()) continue;
            listPromptBuilder.newItem().name(meta.name()).text(meta.displayName()).add();
        }
        listPromptBuilder.addPrompt();
        return promptBuilder;
    }

    private PromptBuilder configureDispatcher(EncryptContext context, DispatcherMeta dispatcherMeta, PromptBuilder promptBuilder) throws Exception {
        context.addInHeader(context.style.italic().bold().foreground(Colors.rgbColor((String)"yellow").intValue()), "Configure " + dispatcherMeta.displayName());
        context.addInHeader("");
        for (DispatcherMeta.Field field : dispatcherMeta.fields()) {
            String fieldKey = field.getKey();
            String fieldDescription = "Configure " + fieldKey + ": " + field.getDescription();
            if (field.getOptions().isPresent()) {
                ListPromptBuilder listPromptBuilder = promptBuilder.createListPrompt().name(fieldKey).message(fieldDescription);
                for (DispatcherMeta.Field option : (List)field.getOptions().get()) {
                    listPromptBuilder.newItem().name(option.getDefaultValue().isPresent() ? (String)option.getDefaultValue().get() : option.getKey()).text(option.getDescription()).add();
                }
                listPromptBuilder.addPrompt();
                continue;
            }
            if (field.getDefaultValue().isPresent()) {
                promptBuilder.createInputPrompt().name(fieldKey).message(fieldDescription).defaultValue((String)field.getDefaultValue().get()).addPrompt();
                continue;
            }
            promptBuilder.createInputPrompt().name(fieldKey).message(fieldDescription).addPrompt();
        }
        return promptBuilder;
    }
}

