/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ServiceLoader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.xml.XmlNode;

public abstract class XmlService {
    public static final String CHILDREN_COMBINATION_MODE_ATTRIBUTE = "combine.children";
    public static final String CHILDREN_COMBINATION_MERGE = "merge";
    public static final String CHILDREN_COMBINATION_APPEND = "append";
    public static final String DEFAULT_CHILDREN_COMBINATION_MODE = "merge";
    public static final String SELF_COMBINATION_MODE_ATTRIBUTE = "combine.self";
    public static final String SELF_COMBINATION_OVERRIDE = "override";
    public static final String SELF_COMBINATION_MERGE = "merge";
    public static final String SELF_COMBINATION_REMOVE = "remove";
    public static final String DEFAULT_SELF_COMBINATION_MODE = "merge";
    public static final String ID_COMBINATION_MODE_ATTRIBUTE = "combine.id";
    public static final String KEYS_COMBINATION_MODE_ATTRIBUTE = "combine.keys";

    @Nullable
    public static XmlNode merge(XmlNode dominant, XmlNode recessive) {
        return XmlService.merge(dominant, recessive, null);
    }

    @Nullable
    public static XmlNode merge(@Nullable XmlNode dominant, @Nullable XmlNode recessive, @Nullable Boolean childMergeOverride) {
        return XmlService.getService().doMerge(dominant, recessive, childMergeOverride);
    }

    @Nonnull
    public static XmlNode read(InputStream input, @Nullable InputLocationBuilder locationBuilder) throws XMLStreamException {
        return XmlService.getService().doRead(input, locationBuilder);
    }

    @Nonnull
    public static XmlNode read(Reader reader) throws XMLStreamException {
        return XmlService.read(reader, null);
    }

    @Nonnull
    public static XmlNode read(Reader reader, @Nullable InputLocationBuilder locationBuilder) throws XMLStreamException {
        return XmlService.getService().doRead(reader, locationBuilder);
    }

    @Nonnull
    public static XmlNode read(XMLStreamReader reader) throws XMLStreamException {
        return XmlService.read(reader, null);
    }

    @Nonnull
    public static XmlNode read(XMLStreamReader reader, @Nullable InputLocationBuilder locationBuilder) throws XMLStreamException {
        return XmlService.getService().doRead(reader, locationBuilder);
    }

    public static void write(XmlNode node, Writer writer) throws IOException {
        XmlService.getService().doWrite(node, writer);
    }

    protected abstract XmlNode doRead(InputStream var1, InputLocationBuilder var2) throws XMLStreamException;

    protected abstract XmlNode doRead(Reader var1, InputLocationBuilder var2) throws XMLStreamException;

    protected abstract XmlNode doRead(XMLStreamReader var1, InputLocationBuilder var2) throws XMLStreamException;

    protected abstract void doWrite(XmlNode var1, Writer var2) throws IOException;

    protected abstract XmlNode doMerge(XmlNode var1, XmlNode var2, Boolean var3);

    private static XmlService getService() {
        return Holder.INSTANCE;
    }

    public static interface InputLocationBuilder {
        public Object toInputLocation(XMLStreamReader var1);
    }

    private static final class Holder {
        static final XmlService INSTANCE = ServiceLoader.load(XmlService.class).findFirst().orElseThrow(() -> new IllegalStateException("No XmlService implementation found"));

        private Holder() {
        }
    }
}

