/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.api.JavaToolchain;
import org.apache.maven.api.Toolchain;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionConstraint;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ToolchainFactory;
import org.apache.maven.api.services.ToolchainFactoryException;
import org.apache.maven.api.services.VersionParser;
import org.apache.maven.api.services.VersionParserException;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.impl.util.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="jdk")
@Singleton
public class DefaultJavaToolchainFactory
implements ToolchainFactory {
    public static final String KEY_JAVAHOME = "jdkHome";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJavaToolchainFactory.class);
    final VersionParser versionParser;

    @Inject
    public DefaultJavaToolchainFactory(VersionParser versionParser) {
        this.versionParser = versionParser;
    }

    @Nonnull
    public JavaToolchain createToolchain(@Nonnull ToolchainModel model) {
        XmlNode javahome;
        Map<String, Predicate<String>> matchers = model.getProvides().entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                throw new ToolchainFactoryException("Provides token '" + key + "' doesn't have any value configured.");
            }
            return "version".equals(key) ? new VersionMatcher(this.versionParser, value) : new ExactMatcher(value);
        }));
        XmlNode dom = model.getConfiguration();
        XmlNode xmlNode = javahome = dom != null ? dom.child(KEY_JAVAHOME) : null;
        if (javahome == null || javahome.value() == null) {
            throw new ToolchainFactoryException("Java toolchain without the jdkHome configuration element.");
        }
        Path normal = Paths.get(javahome.value(), new String[0]).normalize();
        if (!Files.exists(normal, new LinkOption[0])) {
            throw new ToolchainFactoryException("Non-existing JDK home configuration at " + String.valueOf(normal.toAbsolutePath()));
        }
        String javaHome = normal.toString();
        return new DefaultJavaToolchain(model, javaHome, matchers);
    }

    @Nonnull
    public Optional<Toolchain> createDefaultToolchain() {
        return Optional.empty();
    }

    static class DefaultJavaToolchain
    implements JavaToolchain {
        final ToolchainModel model;
        final String javaHome;
        final Map<String, Predicate<String>> matchers;

        DefaultJavaToolchain(ToolchainModel model, String javaHome, Map<String, Predicate<String>> matchers) {
            this.model = model;
            this.javaHome = javaHome;
            this.matchers = matchers;
        }

        public String getJavaHome() {
            return this.javaHome;
        }

        public String getType() {
            return "jdk";
        }

        public ToolchainModel getModel() {
            return this.model;
        }

        public String findTool(String toolName) {
            Path toRet = DefaultJavaToolchain.findTool(toolName, Paths.get(this.getJavaHome(), new String[0]).normalize());
            if (toRet != null) {
                return toRet.toAbsolutePath().toString();
            }
            return null;
        }

        private static Path findTool(String toolName, Path installDir) {
            Path bin = installDir.resolve("bin");
            if (Files.isDirectory(bin, new LinkOption[0])) {
                Path tool;
                if (Os.IS_WINDOWS && Files.exists(tool = bin.resolve(toolName + ".exe"), new LinkOption[0])) {
                    return tool;
                }
                tool = bin.resolve(toolName);
                if (Files.exists(tool, new LinkOption[0])) {
                    return tool;
                }
            }
            return null;
        }

        public boolean matchesRequirements(Map<String, String> requirements) {
            for (Map.Entry<String, String> requirement : requirements.entrySet()) {
                String key = requirement.getKey();
                Predicate<String> matcher = this.matchers.get(key);
                if (matcher == null) {
                    LOGGER.debug("Toolchain {} is missing required property: {}", (Object)this, (Object)key);
                    return false;
                }
                if (matcher.test(requirement.getValue())) continue;
                LOGGER.debug("Toolchain {} doesn't match required property: {}", (Object)this, (Object)key);
                return false;
            }
            return true;
        }

        public String toString() {
            return "JDK[" + this.getJavaHome() + "]";
        }
    }

    static final class VersionMatcher
    implements Predicate<String> {
        final VersionParser versionParser;
        final Version version;

        VersionMatcher(VersionParser versionParser, String version) {
            this.versionParser = versionParser;
            this.version = versionParser.parseVersion(version);
        }

        @Override
        public boolean test(String requirement) {
            try {
                VersionConstraint constraint = this.versionParser.parseVersionConstraint(requirement);
                return constraint.contains(this.version);
            }
            catch (VersionParserException ex) {
                return false;
            }
        }

        public String toString() {
            return this.version.toString();
        }
    }

    static final class ExactMatcher
    implements Predicate<String> {
        final String provides;

        ExactMatcher(String provides) {
            this.provides = provides;
        }

        @Override
        public boolean test(String requirement) {
            return this.provides.equalsIgnoreCase(requirement);
        }

        public String toString() {
            return this.provides;
        }
    }
}

