/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.impl.DefaultSourceRoot;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

class ConnectedResource
extends Resource {
    private final SourceRoot originalSourceRoot;
    private final ProjectScope scope;
    private final MavenProject project;

    ConnectedResource(SourceRoot sourceRoot, ProjectScope scope, MavenProject project) {
        super(org.apache.maven.api.model.Resource.newBuilder().directory(sourceRoot.directory().toString()).includes((Collection)sourceRoot.includes()).excludes((Collection)sourceRoot.excludes()).filtering(Boolean.toString(sourceRoot.stringFiltering())).targetPath((String)sourceRoot.targetPath().map(Path::toString).orElse(null)).build());
        this.originalSourceRoot = sourceRoot;
        this.scope = scope;
        this.project = project;
    }

    public void addInclude(String include) {
        super.addInclude(include);
        this.updateProjectSourceRoot();
    }

    public void removeInclude(String include) {
        super.removeInclude(include);
        this.updateProjectSourceRoot();
    }

    public void addExclude(String exclude) {
        super.addExclude(exclude);
        this.updateProjectSourceRoot();
    }

    public void removeExclude(String exclude) {
        super.removeExclude(exclude);
        this.updateProjectSourceRoot();
    }

    public void setIncludes(List<String> includes) {
        super.setIncludes(includes);
        this.updateProjectSourceRoot();
    }

    public void setExcludes(List<String> excludes) {
        super.setExcludes(excludes);
        this.updateProjectSourceRoot();
    }

    private void updateProjectSourceRoot() {
        ArrayList<SourceRoot> sourcesList = new ArrayList<SourceRoot>(this.project.sources);
        int index = -1;
        for (int i = 0; i < sourcesList.size(); ++i) {
            SourceRoot source = (SourceRoot)sourcesList.get(i);
            if (source.scope() != this.originalSourceRoot.scope() || source.language() != this.originalSourceRoot.language() || !source.directory().equals(this.originalSourceRoot.directory())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            DefaultSourceRoot newSourceRoot = new DefaultSourceRoot(this.project.getBaseDirectory(), this.scope, this.getDelegate());
            sourcesList.set(index, (SourceRoot)newSourceRoot);
            this.project.sources.clear();
            this.project.sources.addAll(sourcesList);
        }
    }
}

