/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;

public class DigestApplet
extends Applet {
    private static final int BUFFER_SIZE = 4096;
    private static final String SHA1 = "SHA1";
    private static final Color BACKGROUND_COLOR = new Color(242, 242, 242);

    public void init() {
        this.setLayout(new FlowLayout());
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(BACKGROUND_COLOR);
        g.fillRect(0, 0, d.width, d.height);
    }

    public String digest(final String filename) {
        return String.valueOf(AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(filename);
                    String string = DigestApplet.this.readAndDigest(in);
                    return string;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string = fileNotFoundException.getMessage();
                    return string;
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                    String string = ioException.getMessage();
                    return string;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ioException) {
                            ioException.printStackTrace();
                            return ioException.getMessage();
                        }
                    }
                }
            }
        }));
    }

    private String readAndDigest(InputStream in) throws IOException {
        byte[] bytes = new byte[4096];
        try {
            int n;
            MessageDigest digest = MessageDigest.getInstance(SHA1);
            while ((n = in.read(bytes)) >= 0) {
                if (n <= 0) continue;
                digest.update(bytes, 0, n);
            }
            bytes = digest.digest();
            StringBuffer sb = new StringBuffer(bytes.length * 2);
            for (int i = 0; i < bytes.length; ++i) {
                int n2 = bytes[i] & 0xFF;
                if (n2 < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(n2));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return noSuchAlgorithmException.getMessage();
        }
    }
}

