/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Marker;

public class BasicMarker
implements Marker {
    private static final long serialVersionUID = 1803952589649545191L;
    final String name;
    List children;
    private static String OPEN = "[ ";
    private static String CLOSE = " ]";
    private static String SEP = ", ";

    BasicMarker(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Marker child) {
        if (child == null) {
            throw new NullPointerException("Null children cannot be added to a Marker.");
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.add(child);
    }

    public synchronized boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public synchronized Iterator iterator() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public synchronized boolean remove(Marker markerToRemove) {
        if (this.children == null) {
            return false;
        }
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Marker m = (Marker)this.children.get(i);
            if (m != markerToRemove) continue;
            return false;
        }
        return false;
    }

    public boolean contains(Marker other) {
        if (other == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this == other) {
            return true;
        }
        if (this.hasChildren()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Marker child = (Marker)this.children.get(i);
                if (!child.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Other cannot be null");
        }
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasChildren()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Marker child = (Marker)this.children.get(i);
                if (!child.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (!this.hasChildren()) {
            return this.getName();
        }
        Iterator it = this.iterator();
        StringBuffer sb = new StringBuffer(this.getName());
        sb.append(' ').append(OPEN);
        while (it.hasNext()) {
            Marker child = (Marker)it.next();
            sb.append(child.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return sb.toString();
    }
}

