/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ServerSocket;
import java.util.Base64;
import java.util.EventListener;
import java.util.HashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.AuthenticationException;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.cli.Handle$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.KyuubiTHttpFrontendService$;
import org.apache.kyuubi.server.http.ThriftHttpServlet;
import org.apache.kyuubi.server.http.util.SessionManager$;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.service.TFrontendService;
import org.apache.kyuubi.service.TFrontendService$;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.THandleIdentifier;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.kyuubi.shaded.thrift.TProcessor;
import org.apache.kyuubi.shaded.thrift.protocol.TBinaryProtocol;
import org.apache.kyuubi.shaded.thrift.protocol.TProtocolFactory;
import org.apache.kyuubi.util.NamedThreadFactory;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u000e\u001d\u0005\u0015B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t%\f\u0005\tc\u0001\u0011\t\u0011)A\u0005]!)!\u0007\u0001C\u0001g!Aq\u0007\u0001EC\u0002\u0013E\u0003\b\u0003\u0005K\u0001!\u0015\r\u0011\"\u0015L\u0011!y\u0005\u0001#b\u0001\n#Z\u0005\u0002\u0003)\u0001\u0011\u000b\u0007I\u0011K)\t\u000fu\u0001\u0001\u0019!C\u00055\"9Q\r\u0001a\u0001\n\u00131\u0007B\u00027\u0001A\u0003&1\fC\u0004n\u0001\t\u0007I\u0011\u00028\t\rQ\u0004\u0001\u0015!\u0003p\u0011\u0015)\b\u0001\"\u0015w\u0011!y\b\u0001#b\u0001\n\u0013Y\u0005bBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003'\u0001A\u0011IA\u000b\u0011\u001d\tY\u0004\u0001C!\u0003{Aq!a\u0010\u0001\t#\ni\u0004C\u0004\u0002B\u0001!\t&a\u0011\t\u0013\u0005-\u0003A1A\u0005B\u00055\u0003\u0002CA,\u0001\u0001\u0006I!a\u0014\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA;\u0001\u0011E\u0013q\u000f\u0005\b\u0003s\u0002A\u0011KA>\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u0013!dS=vk\nLG\u000b\u0013;ua\u001a\u0013xN\u001c;f]\u0012\u001cVM\u001d<jG\u0016T!!\b\u0010\u0002\rM,'O^3s\u0015\ty\u0002%\u0001\u0004lsV,(-\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#BA\u0015\u001f\u0003\u001d\u0019XM\u001d<jG\u0016L!a\u000b\u0015\u0003!Q3%o\u001c8uK:$7+\u001a:wS\u000e,\u0017AC:feZ,'/\u00192mKV\ta\u0006\u0005\u0002(_%\u0011\u0001\u0007\u000b\u0002\u000b'\u0016\u0014h/\u001a:bE2,\u0017aC:feZ,'/\u00192mK\u0002\na\u0001P5oSRtDC\u0001\u001b7!\t)\u0004!D\u0001\u001d\u0011\u0015a3\u00011\u0001/\u0003)\u0019XM\u001d<fe\"{7\u000f^\u000b\u0002sA\u0019!(P \u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012aa\u00149uS>t\u0007C\u0001!H\u001d\t\tU\t\u0005\u0002Cw5\t1I\u0003\u0002EI\u00051AH]8pizJ!AR\u001e\u0002\rA\u0013X\rZ3g\u0013\tA\u0015J\u0001\u0004TiJLgn\u001a\u0006\u0003\rn\nq\u0001]8si:+X.F\u0001M!\tQT*\u0003\u0002Ow\t\u0019\u0011J\u001c;\u0002\u0015\u0005\u001cG/^1m!>\u0014H/\u0001\u0007tKJ4XM]*pG.,G/F\u0001S!\t\u0019\u0006,D\u0001U\u0015\t)f+A\u0002oKRT\u0011aV\u0001\u0005U\u00064\u0018-\u0003\u0002Z)\na1+\u001a:wKJ\u001cvnY6fiV\t1\fE\u0002;{q\u0003\"!X2\u000e\u0003yS!!H0\u000b\u0005\u0001\f\u0017!\u00026fiRL(B\u00012#\u0003\u001d)7\r\\5qg\u0016L!\u0001\u001a0\u0003\rM+'O^3s\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0003O*\u0004\"A\u000f5\n\u0005%\\$\u0001B+oSRDqa[\u0005\u0002\u0002\u0003\u00071,A\u0002yIE\nqa]3sm\u0016\u0014\b%\u0001\nB!Bc\u0015jQ!U\u0013>su\f\u0016%S\u0013\u001a#V#A8\u0011\u0005A\u001cX\"A9\u000b\u0005I4\u0016\u0001\u00027b]\u001eL!\u0001S9\u0002'\u0005\u0003\u0006\u000bT%D\u0003RKuJT0U\u0011JKe\t\u0016\u0011\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001x!\tAX0D\u0001z\u0015\tQ80\u0001\u0003d_:4'B\u0001?!\u0003\u0019A\u0017\rZ8pa&\u0011a0\u001f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002!\u0011,g-Y;mi\u001a+Go\u00195TSj,\u0017AC5oSRL\u0017\r\\5{KR\u0019q-!\u0002\t\ri|\u0001\u0019AA\u0004!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007=\u000511m\u001c8gS\u001eLA!!\u0005\u0002\f\tQ1*_;vE&\u001cuN\u001c4\u0002\u0017=\u0003XM\\*fgNLwN\u001c\u000b\u0005\u0003/\t\t\u0004\u0005\u0003\u0002\u001a\u00055RBAA\u000e\u0015\u0011\ti\"a\b\u0002\rQD'/\u001b4u\u0015\u0011\t\t#a\t\u0002\u0007I\u00048MC\u0002*\u0003KQA!a\n\u0002*\u0005!\u0001.\u001b<f\u0015\r\tYCH\u0001\u0007g\"\fG-\u001a3\n\t\u0005=\u00121\u0004\u0002\u0011)>\u0003XM\\*fgNLwN\u001c*fgBDq!a\r\u0011\u0001\u0004\t)$A\u0002sKF\u0004B!!\u0007\u00028%!\u0011\u0011HA\u000e\u0005=!v\n]3o'\u0016\u001c8/[8o%\u0016\f\u0018a\u0001:v]R\tq-\u0001\u0006ti>\u00048+\u001a:wKJ\f\u0001\"[:TKJ4XM\u001d\u000b\u0003\u0003\u000b\u00022AOA$\u0013\r\tIe\u000f\u0002\b\u0005>|G.Z1o\u0003A!\u0017n]2pm\u0016\u0014\u0018pU3sm&\u001cW-\u0006\u0002\u0002PA!!(PA)!\r9\u00131K\u0005\u0004\u0003+B#aB*feZL7-Z\u0001\u0012I&\u001c8m\u001c<fef\u001cVM\u001d<jG\u0016\u0004\u0013aC4fi\"#H\u000f\u001d)bi\"$2aPA/\u0011\u0019\tyF\u0006a\u0001\u007f\u0005A\u0001\u000e\u001e;q!\u0006$\b.\u0001\u000bd_:\u001cHO]1j]\"#H\u000f]'fi\"|Gm\u001d\u000b\u0004O\u0006\u0015\u0004bBA4/\u0001\u0007\u0011\u0011N\u0001\u000bGRD\b*\u00198eY\u0016\u0014\b\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=t,A\u0004tKJ4H.\u001a;\n\t\u0005M\u0014Q\u000e\u0002\u0016'\u0016\u0014h\u000f\\3u\u0007>tG/\u001a=u\u0011\u0006tG\r\\3s\u000319W\r^%q\u0003\u0012$'/Z:t+\u0005y\u0014!G4fiJ+\u0017\r\\+tKJ\fe\u000eZ*fgNLwN\\+tKJ$B!! \u0002\u0004B)!(a @\u007f%\u0019\u0011\u0011Q\u001e\u0003\rQ+\b\u000f\\33\u0011\u001d\t\u0019$\u0007a\u0001\u0003k\tAbZ3u'\"|'\u000f\u001e(b[\u0016$2aPAE\u0011\u0019\tYI\u0007a\u0001\u007f\u0005AQo]3s\u001d\u0006lW\r")
public final class KyuubiTHttpFrontendService
extends TFrontendService {
    private Option<String> serverHost;
    private int portNum;
    private int actualPort;
    private ServerSocket serverSocket;
    private int defaultFetchSize;
    private final Serverable serverable;
    private Option<Server> server;
    private final String APPLICATION_THRIFT;
    private final Option<Service> discoveryService;
    private volatile byte bitmap$0;

    public Serverable serverable() {
        return this.serverable;
    }

    private Option<String> serverHost$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serverHost = (Option)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_BIND_HOST());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serverHost;
    }

    public Option<String> serverHost() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.serverHost$lzycompute();
        }
        return this.serverHost;
    }

    private int portNum$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.portNum = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_BIND_PORT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.portNum;
    }

    public int portNum() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.portNum$lzycompute();
        }
        return this.portNum;
    }

    private int actualPort$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.actualPort = this.portNum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.actualPort;
    }

    public int actualPort() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.actualPort$lzycompute();
        }
        return this.actualPort;
    }

    private ServerSocket serverSocket$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.serverSocket = null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.serverSocket;
    }

    public ServerSocket serverSocket() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.serverSocket$lzycompute();
        }
        return this.serverSocket;
    }

    private Option<Server> server() {
        return this.server;
    }

    private void server_$eq(Option<Server> x$1) {
        this.server = x$1;
    }

    private String APPLICATION_THRIFT() {
        return this.APPLICATION_THRIFT;
    }

    public Configuration hadoopConf() {
        return KyuubiServer$.MODULE$.getHadoopConf();
    }

    private int defaultFetchSize$lzycompute() {
        KyuubiTHttpFrontendService kyuubiTHttpFrontendService = this;
        synchronized (kyuubiTHttpFrontendService) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.defaultFetchSize = BoxesRunTime.unboxToInt((Object)this.conf().get(KyuubiConf$.MODULE$.KYUUBI_SERVER_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.defaultFetchSize;
    }

    private int defaultFetchSize() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.defaultFetchSize$lzycompute();
        }
        return this.defaultFetchSize;
    }

    public synchronized void initialize(KyuubiConf conf) {
        this.conf_$eq(conf);
        if (this.authFactory().kerberosEnabled() && this.authFactory().effectivePlainAuthType().isEmpty()) {
            throw new AuthenticationException("Kerberos is not supported for Thrift HTTP mode");
        }
        try {
            ServerConnector serverConnector;
            String schemeName;
            int minThreads = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MIN_WORKER_THREADS()));
            int maxThreads = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_MAX_WORKER_THREADS()));
            long keepAliveTime = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_WORKER_KEEPALIVE_TIME()));
            ThreadPoolExecutor executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(new StringBuilder(16).append(this.getName()).append("HttpHandler-Pool").toString(), false));
            ExecutorThreadPool threadPool = new ExecutorThreadPool(executor);
            this.server_$eq((Option<Server>)new Some((Object)new Server((ThreadPool)threadPool)));
            HttpConfiguration httpConf = new HttpConfiguration();
            int requestHeaderSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_REQUEST_HEADER_SIZE()));
            int responseHeaderSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_RESPONSE_HEADER_SIZE()));
            boolean jettySendVersionEnabled = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_JETTY_SEND_VERSION_ENABLED()));
            httpConf.setRequestHeaderSize(requestHeaderSize);
            httpConf.setResponseHeaderSize(responseHeaderSize);
            httpConf.setSendServerVersion(jettySendVersionEnabled);
            HttpConnectionFactory connectionFactory = new HttpConnectionFactory(httpConf);
            boolean useSsl = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_USE_SSL()));
            String string = schemeName = useSsl ? "https" : "http";
            if (useSsl) {
                Option keyStorePath = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH());
                if (keyStorePath.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(61).append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH().key()).append(" Not configured for SSL connection, please set the key with: ").append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PATH().doc()).toString());
                }
                Option keyStorePassword = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD());
                if (keyStorePassword.isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(61).append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD().key()).append(" Not configured for SSL connection. please set the key with: ").append(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_KEYSTORE_PASSWORD().doc()).toString());
                }
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                Seq excludedProtocols = (Seq)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_PROTOCOL_BLACKLIST());
                Seq excludeCipherSuites = (Seq)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_SSL_EXCLUDE_CIPHER_SUITES());
                Option keyStoreType = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_TYPE());
                Option keyStoreAlgorithm = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.FRONTEND_SSL_KEYSTORE_ALGORITHM());
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Thrift HTTP Server SSL: adding excluded protocols: ").append(String.join((CharSequence)",", (CharSequence[])excludedProtocols.toArray(ClassTag$.MODULE$.apply(String.class)))).toString());
                sslContextFactory.addExcludeProtocols((String[])excludedProtocols.toArray(ClassTag$.MODULE$.apply(String.class)));
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Thrift HTTP Server SSL: SslContextFactory.getExcludeProtocols = ").append(String.join((CharSequence)",", sslContextFactory.getExcludeProtocols())).toString());
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Thrift HTTP Server SSL: setting excluded cipher Suites: ").append(String.join((CharSequence)",", (CharSequence[])excludeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class)))).toString());
                sslContextFactory.setExcludeCipherSuites((String[])excludeCipherSuites.toArray(ClassTag$.MODULE$.apply(String.class)));
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Thrift HTTP Server SSL: SslContextFactory.getExcludeCipherSuites = ").append(String.join((CharSequence)",", sslContextFactory.getExcludeCipherSuites())).toString());
                sslContextFactory.setKeyStorePath((String)keyStorePath.get());
                sslContextFactory.setKeyStorePassword((String)keyStorePassword.get());
                keyStoreType.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    sslContextFactory.setKeyStoreType(x$1);
                    return BoxedUnit.UNIT;
                });
                keyStoreAlgorithm.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    sslContextFactory.setKeyManagerFactoryAlgorithm(x$1);
                    return BoxedUnit.UNIT;
                });
                serverConnector = new ServerConnector((Server)this.server().get(), (SslContextFactory)sslContextFactory, new ConnectionFactory[]{connectionFactory});
            } else {
                serverConnector = new ServerConnector((Server)this.server().get(), new ConnectionFactory[]{connectionFactory});
            }
            ServerConnector connector = serverConnector;
            connector.setPort(this.portNum());
            connector.setReuseAddress(!SystemUtils.IS_OS_WINDOWS);
            long maxIdleTime = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_MAX_IDLE_TIME()));
            connector.setIdleTimeout(maxIdleTime);
            connector.setAcceptQueueSize(maxThreads);
            this.server().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.addConnector((Connector)connector);
                return BoxedUnit.UNIT;
            });
            TCLIService.Processor processor = new TCLIService.Processor((TCLIService.Iface)this);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            ThriftHttpServlet servlet = new ThriftHttpServlet((TProcessor)processor, (TProtocolFactory)protocolFactory, this.authFactory(), conf);
            servlet.init();
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            context.addEventListener((EventListener)new ServletContextListener(null){

                public void contextInitialized(ServletContextEvent servletContextEvent) {
                    MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                        $anon$1.$anonfun$contextInitialized$1(ms);
                        return BoxedUnit.UNIT;
                    });
                }

                public void contextDestroyed(ServletContextEvent servletContextEvent) {
                    MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                        $anon$1.$anonfun$contextDestroyed$1(ms);
                        return BoxedUnit.UNIT;
                    });
                }

                public static final /* synthetic */ void $anonfun$contextInitialized$1(MetricsSystem ms) {
                    ms.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_TOTAL());
                    ms.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_OPEN());
                }

                public static final /* synthetic */ void $anonfun$contextDestroyed$1(MetricsSystem ms) {
                    ms.decCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_OPEN());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$contextInitialized$1$adapted(org.apache.kyuubi.metrics.MetricsSystem ), $anonfun$contextDestroyed$1$adapted(org.apache.kyuubi.metrics.MetricsSystem )}, serializedLambda);
                }
            });
            String httpPath = this.getHttpPath((String)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_PATH()));
            if (BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.FRONTEND_THRIFT_HTTP_COMPRESSION_ENABLED()))) {
                GzipHandler gzipHandler = new GzipHandler();
                gzipHandler.setHandler((Handler)context);
                gzipHandler.addIncludedMethods(new String[]{HttpMethod.POST.asString()});
                gzipHandler.addIncludedMimeTypes(new String[]{this.APPLICATION_THRIFT()});
                this.server().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.setHandler((Handler)gzipHandler);
                    return BoxedUnit.UNIT;
                });
            } else {
                this.server().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.setHandler((Handler)context);
                    return BoxedUnit.UNIT;
                });
            }
            context.addServlet(new ServletHolder((Servlet)servlet), httpPath);
            this.constrainHttpMethods(context);
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Started ").append(this.getClass().getSimpleName()).append(" in ").append(schemeName).append(" mode on port ").append(this.portNum()).append(" ").append("path=").append(httpPath).append(" with ").append(minThreads).append(" ... ").append(maxThreads).append(" threads").toString());
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.incCount(MetricsConstants$.MODULE$.THRIFT_HTTP_CONN_FAIL());
                return BoxedUnit.UNIT;
            });
            this.error((Function0 & Serializable & scala.Serializable)() -> e);
            throw new KyuubiException(new StringBuilder(43).append("Failed to initialize frontend service on ").append(this.serverAddr()).append(":").append(this.portNum()).append(".").toString(), e);
        }
        super.initialize(conf);
    }

    public TOpenSessionResp OpenSession(TOpenSessionReq req) {
        this.debug((Function0 & Serializable & scala.Serializable)() -> req.toString());
        this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Client protocol version: ").append(req.getClient_protocol()).toString());
        TOpenSessionResp resp = new TOpenSessionResp();
        try {
            SessionHandle sessionHandle = this.getSessionHandle(req, resp);
            HashMap<String, String> respConfiguration = new HashMap<String, String>();
            Operation launchEngineOp = ((KyuubiSessionImpl)this.be().sessionManager().getSession(sessionHandle)).launchEngineOp();
            THandleIdentifier opHandleIdentifier = Handle$.MODULE$.toTHandleIdentifier(launchEngineOp.getHandle().identifier());
            respConfiguration.put("kyuubi.session.engine.launch.handle.guid", Base64.getEncoder().encodeToString(opHandleIdentifier.getGuid()));
            respConfiguration.put("kyuubi.session.engine.launch.handle.secret", Base64.getEncoder().encodeToString(opHandleIdentifier.getSecret()));
            respConfiguration.put("kyuubi.session.engine.launch.support.result", Boolean.toString(true));
            respConfiguration.put("hive.server2.thrift.resultset.default.fetch.size", Integer.toString(this.defaultFetchSize()));
            resp.setSessionHandle(sessionHandle.toTSessionHandle());
            resp.setConfiguration(respConfiguration);
            resp.setStatus(TFrontendService$.MODULE$.OK_STATUS());
            Option$.MODULE$.apply(TFrontendService$.MODULE$.CURRENT_SERVER_CONTEXT().get()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.setSessionHandle(sessionHandle);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> "Error opening session: ", e);
            resp.setStatus(KyuubiSQLException$.MODULE$.toTStatus(e, true));
        }
        return resp;
    }

    public void run() {
        try {
            if (this.isServer()) {
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Starting and exposing JDBC connection at: jdbc:hive2://").append(this.connectionUrl()).append("/").toString());
            }
            this.server().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.start();
                return BoxedUnit.UNIT;
            });
        }
        catch (InterruptedException interruptedException) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append(this.getName()).append(" is interrupted").toString());
        }
        catch (Throwable t) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Error starting ").append(this.getName()).toString(), t);
            System.exit(-1);
        }
    }

    public void stopServer() {
        this.server().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.stop();
            return BoxedUnit.UNIT;
        });
        this.server_$eq((Option<Server>)None$.MODULE$);
    }

    public boolean isServer() {
        return true;
    }

    public Option<Service> discoveryService() {
        return this.discoveryService;
    }

    private String getHttpPath(String httpPath) {
        block7: {
            block6: {
                if (httpPath == null) break block6;
                String string = httpPath;
                String string2 = "";
                if (string != null ? !string.equals(string2) : string2 != null) break block7;
            }
            return "/*";
        }
        if (!httpPath.startsWith("/")) {
            return new StringBuilder(1).append("/").append(httpPath).toString();
        }
        if (httpPath.endsWith("/")) {
            return new StringBuilder(1).append(httpPath).append("*").toString();
        }
        if (!httpPath.endsWith("/*")) {
            return new StringBuilder(2).append(httpPath).append("/*").toString();
        }
        return httpPath;
    }

    public void constrainHttpMethods(ServletContextHandler ctxHandler) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        ConstraintMapping cmt = new ConstraintMapping();
        cmt.setConstraint(constraint);
        cmt.setMethod("TRACE");
        cmt.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        ConstraintMapping cmo = new ConstraintMapping();
        cmo.setConstraint(constraint);
        cmo.setMethod("OPTIONS");
        cmo.setPathSpec("/*");
        securityHandler.setConstraintMappings((ConstraintMapping[])((Object[])new ConstraintMapping[]{cmt, cmo}));
        ctxHandler.setSecurityHandler((SecurityHandler)securityHandler);
    }

    public String getIpAddress() {
        return (String)Option$.MODULE$.apply((Object)SessionManager$.MODULE$.getProxyHttpHeaderIpAddress()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SessionManager$.MODULE$.getIpAddress());
    }

    public Tuple2<String, String> getRealUserAndSessionUser(TOpenSessionReq req) {
        String realUser = this.getShortName((String)Option$.MODULE$.apply((Object)SessionManager$.MODULE$.getUserName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> req.getUsername()));
        String ipAddress = SessionManager$.MODULE$.getIpAddress();
        String sessionUser = req.getConfiguration() == null ? realUser : this.getProxyUser(req.getConfiguration(), ipAddress, realUser);
        this.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Client's real user: ").append(realUser).append(", session user: ").append(sessionUser).toString());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)realUser), (Object)sessionUser);
    }

    private String getShortName(String userName) {
        String ret;
        block0: {
            ret = null;
            if (userName == null) break block0;
            int indexOfDomainMatch = ServiceUtils$.MODULE$.indexOfDomainMatch(userName);
            ret = indexOfDomainMatch <= 0 ? userName : userName.substring(0, indexOfDomainMatch);
        }
        return ret;
    }

    public KyuubiTHttpFrontendService(Serverable serverable) {
        this.serverable = serverable;
        super("KyuubiTHttpFrontendService");
        this.server = None$.MODULE$;
        this.APPLICATION_THRIFT = "application/x-thrift";
        this.discoveryService = None$.MODULE$;
    }
}

