/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import scala.Tuple2;

public final class SignUtils$ {
    public static final SignUtils$ MODULE$ = new SignUtils$();
    private static KeyPairGenerator ecKeyPairGenerator;
    private static final String KEYPAIR_ALGORITHM_EC;
    private static volatile boolean bitmap$0;

    static {
        KEYPAIR_ALGORITHM_EC = "EC";
    }

    public String KEYPAIR_ALGORITHM_EC() {
        return KEYPAIR_ALGORITHM_EC;
    }

    /*
     * WARNING - void declaration
     */
    private KeyPairGenerator ecKeyPairGenerator$lzycompute() {
        SignUtils$ signUtils$ = this;
        synchronized (signUtils$) {
            if (!bitmap$0) {
                void var2_2;
                KeyPairGenerator g = KeyPairGenerator.getInstance(this.KEYPAIR_ALGORITHM_EC());
                g.initialize(new ECGenParameterSpec("secp521r1"), new SecureRandom());
                ecKeyPairGenerator = var2_2;
                bitmap$0 = true;
            }
        }
        return ecKeyPairGenerator;
    }

    private KeyPairGenerator ecKeyPairGenerator() {
        return !bitmap$0 ? this.ecKeyPairGenerator$lzycompute() : ecKeyPairGenerator;
    }

    public Tuple2<PrivateKey, PublicKey> generateKeyPair(String algorithm) {
        KeyPairGenerator keyPairGenerator;
        block3: {
            String string = algorithm.toUpperCase();
            switch (string == null ? 0 : string.hashCode()) {
                case 2206: {
                    if (!"EC".equals(string)) break;
                    keyPairGenerator = this.ecKeyPairGenerator();
                    break block3;
                }
            }
            throw new InvalidParameterException(new StringBuilder(48).append("algorithm ").append(algorithm).append(" not supported for key pair generation").toString());
        }
        KeyPairGenerator generator = keyPairGenerator;
        KeyPair keyPair = generator.generateKeyPair();
        return new Tuple2((Object)keyPair.getPrivate(), (Object)keyPair.getPublic());
    }

    public String generateKeyPair$default$1() {
        return "EC";
    }

    public String signWithPrivateKey(String plainText, PrivateKey privateKey, String algorithm) {
        Signature privateSignature = Signature.getInstance(algorithm);
        privateSignature.initSign(privateKey);
        privateSignature.update(plainText.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = privateSignature.sign();
        return Base64.getEncoder().encodeToString(signatureBytes);
    }

    public String signWithPrivateKey$default$3() {
        return "SHA256withECDSA";
    }

    public boolean verifySignWithECDSA(String plainText, String signatureBase64, String publicKeyBase64) {
        boolean bl;
        try {
            byte[] publicKeyBytes = Base64.getDecoder().decode(publicKeyBase64);
            ECPublicKey publicKey = (ECPublicKey)KeyFactory.getInstance(this.KEYPAIR_ALGORITHM_EC()).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            byte[] signatureBytes = Base64.getDecoder().decode(signatureBase64);
            Signature publicSignature = Signature.getInstance("SHA256withECDSA");
            publicSignature.initVerify(publicKey);
            publicSignature.update(plainText.getBytes(StandardCharsets.UTF_8));
            bl = publicSignature.verify(signatureBytes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(47).append("signature verification failed: publicKeyBase64:").append(publicKeyBase64).toString()).append(new StringBuilder(30).append(", signatureBase64:").append(signatureBase64).append(", plainText:").append(plainText).toString()).toString(), e);
        }
        return bl;
    }

    private SignUtils$() {
    }
}

