/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.security.auth.Subject;
import org.apache.kyuubi.client.auth.AuthHeaderGenerator;
import org.apache.kyuubi.client.exception.KyuubiRestException;
import org.apache.kyuubi.util.reflect.DynFields;
import org.apache.kyuubi.util.reflect.DynMethods;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpnegoAuthHeaderGenerator
implements AuthHeaderGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SpnegoAuthHeaderGenerator.class);
    private static final String UGI_CLASS = "org.apache.hadoop.security.UserGroupInformation";
    private final String spnegoHost;

    public SpnegoAuthHeaderGenerator(String spnegoHost) {
        this.spnegoHost = spnegoHost;
    }

    @Override
    public String generateAuthHeader() {
        try {
            return "NEGOTIATE " + this.generateToken(this.spnegoHost);
        }
        catch (KyuubiRestException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new KyuubiRestException("Failed to generate spnego auth header for " + this.spnegoHost, e);
        }
    }

    private String generateToken(String server) throws Exception {
        Subject subject;
        try {
            Object ugiCurrentUser = DynMethods.builder((String)"getCurrentUser").hiddenImpl(Class.forName(UGI_CLASS), new Class[0]).buildStaticChecked().invoke(new Object[0]);
            LOG.debug("The user credential is {}", ugiCurrentUser);
            subject = (Subject)DynFields.builder().hiddenImpl(ugiCurrentUser.getClass(), "subject").buildChecked(ugiCurrentUser).get();
        }
        catch (ClassNotFoundException e) {
            LOG.error("Hadoop UGI class {} is required for SPNEGO authentication.", (Object)UGI_CLASS);
            throw e;
        }
        return Subject.doAs(subject, () -> this.doGenerateToken(server));
    }

    private String doGenerateToken(String server) throws GSSException {
        GSSManager manager = GSSManager.getInstance();
        GSSName serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
        GSSName peer = serverName.canonicalize(null);
        GSSContext gssContext = manager.createContext(peer, null, null, 0);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        byte[] inToken = new byte[]{};
        byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
        gssContext.dispose();
        LOG.debug("Got valid challenge for host {}", (Object)serverName);
        return new String(Base64.getEncoder().encode(outToken), StandardCharsets.US_ASCII);
    }
}

