/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.SparkSQLEngine$;
import org.apache.kyuubi.engine.spark.operation.SparkSQLOperationManager;
import org.apache.kyuubi.engine.spark.session.SparkSessionImpl;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.util.ThreadUtils$;
import org.apache.spark.api.python.KyuubiPythonGatewayServer$;
import org.apache.spark.sql.SparkSession;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mg\u0001B\u0010!\u00015B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tG\u0001\u0011\t\u0011)A\u0005\u0003\")\u0001\n\u0001C\u0005\u0013\")\u0001\n\u0001C\u0001\u001d\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002-\u0001A\u0003%!\u000b\u0003\u0005Z\u0001!\u0015\r\u0011\"\u0003[\u0011!y\u0006\u0001#b\u0001\n\u0013\u0001\u0007\u0002\u00036\u0001\u0011\u000b\u0007I\u0011\u0002.\t\u0011-\u0004\u0001R1A\u0005\n1D\u0001\u0002\u001d\u0001\t\u0006\u0004%I\u0001\u001c\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0011\u0019Y\b\u0001)A\u0005g\"AA\u0010\u0001EC\u0002\u0013%Q\u0010\u0003\u0006\u0002\n\u0001A)\u0019!C\u0005\u0003\u0017A\u0011\"a\b\u0001\u0001\u0004%I!!\t\t\u0013\u0005U\u0002\u00011A\u0005\n\u0005]\u0002\u0002CA\"\u0001\u0001\u0006K!a\t\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u0011\u0011\n\u0001\u0005B\u0005\u001d\u0003bBA&\u0001\u0011\u0005\u0013q\t\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!!\u0018\u0001\t#\ny\u0006C\u0004\u0002\u001c\u0002!\t%!(\t\u000f\u0005%\u0006\u0001\"\u0003\u0002H!1\u00111\u0016\u0001\u0005RiC\u0001\"!,\u0001\t\u0003\u0011\u0013q\u0016\u0005\b\u0003\u0003\u0004A\u0011BAb\u0011!\t9\r\u0001C\u0001E\u0005%'AF*qCJ\\7+\u0015'TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\u0005\u0012\u0013aB:fgNLwN\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0015tw-\u001b8f\u0015\t9\u0003&\u0001\u0004lsV,(-\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0003CA\u00182\u001b\u0005\u0001$BA\u0011'\u0013\t\u0011\u0004G\u0001\bTKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\t9\fW.\u001a\t\u0003kyr!A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eb\u0013A\u0002\u001fs_>$hHC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f;!\t\u0011e)D\u0001D\u0015\t!U)A\u0002tc2T!a\t\u0015\n\u0005\u001d\u001b%\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\bF\u0002K\u00196\u0003\"a\u0013\u0001\u000e\u0003\u0001BQaM\u0002A\u0002QBQaI\u0002A\u0002\u0005#\"AS(\t\u000b\r\"\u0001\u0019A!\u0002!=\u0004XM]1uS>tW*\u00198bO\u0016\u0014X#\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0005U\u0013\u0013!C8qKJ\fG/[8o\u0013\t9FK\u0001\rTa\u0006\u00148nU)M\u001fB,'/\u0019;j_:l\u0015M\\1hKJ\f\u0011c\u001c9fe\u0006$\u0018n\u001c8NC:\fw-\u001a:!\u0003I\u0019\u0018N\\4mKN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0016\u0003m\u0003\"\u0001X/\u000e\u0003iJ!A\u0018\u001e\u0003\u000f\t{w\u000e\\3b]\u0006Q1\u000f[1sK2+g/\u001a7\u0016\u0003\u0005\u0004\"A\u00194\u000f\u0005\r$W\"\u0001\u0013\n\u0005\u0015$\u0013AC*iCJ,G*\u001a<fY&\u0011q\r\u001b\u0002\u0006-\u0006dW/Z\u0005\u0003Sj\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006ARo]3s\u0013N|G.\u0019;fIN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u00021U\u001cXM]%t_2\fG/\u001a3JI2,\u0017J\u001c;feZ\fG.F\u0001n!\taf.\u0003\u0002pu\t!Aj\u001c8h\u0003])8/\u001a:Jg>d\u0017\r^3e\u0013\u0012dW\rV5nK>,H/A\u000bvg\u0016\u0014\u0018j]8mCR,GmQ1dQ\u0016dunY6\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t1\fgn\u001a\u0006\u0002q\u0006!!.\u0019<b\u0013\tQXO\u0001\u0004PE*,7\r^\u0001\u0017kN,'/S:pY\u0006$X\rZ\"bG\",Gj\\2lA\u0005\tRo]3s\u0013N|G.\u0019;fI\u000e\u000b7\r[3\u0016\u0003y\u0004Ra`A\u0003i\u0005k!!!\u0001\u000b\u0007\u0005\rq/\u0001\u0003vi&d\u0017\u0002BA\u0004\u0003\u0003\u0011q\u0001S1tQ6\u000b\u0007/\u0001\fvg\u0016\u0014\u0018j]8mCR,GmQ1dQ\u0016\u001cu.\u001e8u+\t\ti\u0001\u0005\u0004\u0000\u0003\u000b!\u0014q\u0002\t\b9\u0006E\u0011QCA\u000e\u0013\r\t\u0019B\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007Q\f9\"C\u0002\u0002\u001aU\u0014q!\u00138uK\u001e,'\u000fE\u0002u\u0003;I!a\\;\u0002=U\u001cXM]%t_2\fG/\u001a3Ta\u0006\u00148nU3tg&|g\u000e\u00165sK\u0006$WCAA\u0012!\u0015a\u0016QEA\u0015\u0013\r\t9C\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[QA!a\f\u0002\u0002\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005M\u0012Q\u0006\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AI;tKJL5o\u001c7bi\u0016$7\u000b]1sWN+7o]5p]RC'/Z1e?\u0012*\u0017\u000f\u0006\u0003\u0002:\u0005}\u0002c\u0001/\u0002<%\u0019\u0011Q\b\u001e\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0003\n\u0012\u0011!a\u0001\u0003G\t1\u0001\u001f\u00132\u0003})8/\u001a:Jg>d\u0017\r^3e'B\f'o[*fgNLwN\u001c+ie\u0016\fG\rI\u0001\u001egR\f'\u000f^+tKJL5o\u001c7bi\u0016$7)Y2iK\u000eCWmY6feR\u0011\u0011\u0011H\u0001\u0006gR\f'\u000f^\u0001\u0005gR|\u0007/\u0001\u000bhKR|%OT3x'B\f'o[*fgNLwN\u001c\u000b\u0004\u0003\u0006E\u0003BBA*-\u0001\u0007A'\u0001\u0003vg\u0016\u0014\u0018a\u00048foN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0015\u0007\u0005\u000bI\u0006\u0003\u0004\u0002\\]\u0001\r!Q\u0001\u0011e>|Go\u00159be.\u001cVm]:j_:\fQb\u0019:fCR,7+Z:tS>tG\u0003DA1\u0003O\n9)!#\u0002\u000e\u0006E\u0005cA\u0018\u0002d%\u0019\u0011Q\r\u0019\u0003\u000fM+7o]5p]\"9\u0011\u0011\u000e\rA\u0002\u0005-\u0014\u0001\u00039s_R|7m\u001c7\u0011\t\u00055\u00141Q\u0007\u0003\u0003_RA!!\u001d\u0002t\u00051A\u000f\u001b:jMRTA!!\u001e\u0002x\u0005\u0019!\u000f]2\u000b\t\u0005e\u00141P\u0001\bg\u0016\u0014h/[2f\u0015\u0011\ti(a \u0002\t!Lg/\u001a\u0006\u0004\u0003\u00033\u0013AB:iC\u0012,G-\u0003\u0003\u0002\u0006\u0006=$\u0001\u0005+Qe>$xnY8m-\u0016\u00148/[8o\u0011\u0019\t\u0019\u0006\u0007a\u0001i!1\u00111\u0012\rA\u0002Q\n\u0001\u0002]1tg^|'\u000f\u001a\u0005\u0007\u0003\u001fC\u0002\u0019\u0001\u001b\u0002\u0013%\u0004\u0018\t\u001a3sKN\u001c\bbBAJ1\u0001\u0007\u0011QS\u0001\u0005G>tg\rE\u00036\u0003/#D'C\u0002\u0002\u001a\u0002\u00131!T1q\u00031\u0019Gn\\:f'\u0016\u001c8/[8o)\u0011\tI$a(\t\u000f\u0005\u0005\u0016\u00041\u0001\u0002$\u0006i1/Z:tS>t\u0007*\u00198eY\u0016\u00042aLAS\u0013\r\t9\u000b\r\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\u0002\u0017M$x\u000e]*fgNLwN\\\u0001\tSN\u001cVM\u001d<fe\u00069r-\u001a;F]\u001eLg.\u001a*fgVdGoU1wKB\u000bG\u000f\u001b\u000b\u0003\u0003c\u0003B!a-\u0002>6\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000bI,\u0001\u0002gg*\u0019\u00111\u0018\u0015\u0002\r!\fGm\\8q\u0013\u0011\ty,!.\u0003\tA\u000bG\u000f[\u0001\u0019O\u0016$8+Z:tS>t'+Z:vYR\u001c\u0016M^3QCRDG\u0003BAY\u0003\u000bDq!!)\u001e\u0001\u0004\t\u0019+\u0001\u000ehKR|\u0005/\u001a:bi&|gNU3tk2$8+\u0019<f!\u0006$\b\u000e\u0006\u0004\u00022\u0006-\u0017Q\u001a\u0005\b\u0003Cs\u0002\u0019AAR\u0011\u001d\tyM\ba\u0001\u0003#\f\u0001b\u001c9IC:$G.\u001a\t\u0005\u0003'\f9.\u0004\u0002\u0002V*\u0011QKJ\u0005\u0005\u00033\f)NA\bPa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f\u0001")
public class SparkSQLSessionManager
extends SessionManager {
    private boolean singleSparkSession;
    private Enumeration.Value shareLevel;
    private boolean userIsolatedSparkSession;
    private long userIsolatedIdleInterval;
    private long userIsolatedIdleTimeout;
    private HashMap<String, SparkSession> userIsolatedCache;
    private HashMap<String, Tuple2<Integer, Long>> userIsolatedCacheCount;
    private final SparkSession spark;
    private final SparkSQLOperationManager operationManager;
    private final Object userIsolatedCacheLock;
    private Option<ScheduledExecutorService> userIsolatedSparkSessionThread;
    private volatile byte bitmap$0;

    @Override
    public SparkSQLOperationManager operationManager() {
        return this.operationManager;
    }

    private boolean singleSparkSession$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.singleSparkSession = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_SINGLE_SPARK_SESSION()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.singleSparkSession;
    }

    private boolean singleSparkSession() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.singleSparkSession$lzycompute();
        }
        return this.singleSparkSession;
    }

    private Enumeration.Value shareLevel$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.shareLevel = ShareLevel$.MODULE$.withName(this.conf().get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.shareLevel;
    }

    private Enumeration.Value shareLevel() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.shareLevel$lzycompute();
        }
        return this.shareLevel;
    }

    private boolean userIsolatedSparkSession$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.userIsolatedSparkSession = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_USER_ISOLATED_SPARK_SESSION()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.userIsolatedSparkSession;
    }

    private boolean userIsolatedSparkSession() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.userIsolatedSparkSession$lzycompute();
        }
        return this.userIsolatedSparkSession;
    }

    private long userIsolatedIdleInterval$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.userIsolatedIdleInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_USER_ISOLATED_SPARK_SESSION_IDLE_INTERVAL()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.userIsolatedIdleInterval;
    }

    private long userIsolatedIdleInterval() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.userIsolatedIdleInterval$lzycompute();
        }
        return this.userIsolatedIdleInterval;
    }

    private long userIsolatedIdleTimeout$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.userIsolatedIdleTimeout = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_USER_ISOLATED_SPARK_SESSION_IDLE_TIMEOUT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.userIsolatedIdleTimeout;
    }

    private long userIsolatedIdleTimeout() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.userIsolatedIdleTimeout$lzycompute();
        }
        return this.userIsolatedIdleTimeout;
    }

    private Object userIsolatedCacheLock() {
        return this.userIsolatedCacheLock;
    }

    private HashMap<String, SparkSession> userIsolatedCache$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.userIsolatedCache = new HashMap();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.userIsolatedCache;
    }

    private HashMap<String, SparkSession> userIsolatedCache() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.userIsolatedCache$lzycompute();
        }
        return this.userIsolatedCache;
    }

    private HashMap<String, Tuple2<Integer, Long>> userIsolatedCacheCount$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.userIsolatedCacheCount = new HashMap();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.userIsolatedCacheCount;
    }

    private HashMap<String, Tuple2<Integer, Long>> userIsolatedCacheCount() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.userIsolatedCacheCount$lzycompute();
        }
        return this.userIsolatedCacheCount;
    }

    private Option<ScheduledExecutorService> userIsolatedSparkSessionThread() {
        return this.userIsolatedSparkSessionThread;
    }

    private void userIsolatedSparkSessionThread_$eq(Option<ScheduledExecutorService> x$1) {
        this.userIsolatedSparkSessionThread = x$1;
    }

    private void startUserIsolatedCacheChecker() {
        if (!this.userIsolatedSparkSession()) {
            this.userIsolatedSparkSessionThread_$eq((Option<ScheduledExecutorService>)new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("user-isolated-cache-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2())));
            this.userIsolatedSparkSessionThread().foreach((Function1 & Serializable & scala.Serializable)thread -> {
                ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(thread, () -> {
                    Object object = $this.userIsolatedCacheLock();
                    synchronized (object) {
                        Iterator<Map.Entry<String, Tuple2<Integer, Long>>> iter = $this.userIsolatedCacheCount().entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry<String, Tuple2<Integer, Long>> kv = iter.next();
                            if (!BoxesRunTime.equals((Object)kv.getValue()._1(), (Object)BoxesRunTime.boxToInteger((int)0)) || Predef$.MODULE$.Long2long((Long)kv.getValue()._2()) + $this.userIsolatedIdleTimeout() >= System.currentTimeMillis()) continue;
                            $this.userIsolatedCache().remove(kv.getKey());
                            iter.remove();
                        }
                    }
                }, this.userIsolatedIdleInterval(), this.userIsolatedIdleInterval(), TimeUnit.MILLISECONDS);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void start() {
        this.startUserIsolatedCacheChecker();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        KyuubiPythonGatewayServer$.MODULE$.shutdown();
        this.userIsolatedSparkSessionThread().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    private SparkSession getOrNewSparkSession(String user) {
        boolean bl;
        boolean bl2;
        if (this.singleSparkSession()) {
            return this.spark;
        }
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return this.spark;
        }
        Enumeration.Value value4 = ShareLevel$.MODULE$.USER();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return this.newSparkSession(this.spark);
        }
        Enumeration.Value value6 = ShareLevel$.MODULE$.GROUP();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            bl2 = true;
        } else {
            Enumeration.Value value8 = ShareLevel$.MODULE$.SERVER();
            Enumeration.Value value9 = value;
            bl2 = !(value8 != null ? !value8.equals(value9) : value9 != null);
        }
        if (bl2 && this.userIsolatedSparkSession()) {
            return this.newSparkSession(this.spark);
        }
        Enumeration.Value value10 = ShareLevel$.MODULE$.GROUP();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            bl = true;
        } else {
            Enumeration.Value value12 = ShareLevel$.MODULE$.SERVER();
            Enumeration.Value value13 = value;
            bl = !(value12 != null ? !value12.equals(value13) : value13 != null);
        }
        if (bl) {
            SparkSession sparkSession;
            Object object = this.userIsolatedCacheLock();
            synchronized (object) {
                SparkSession sparkSession2;
                if (this.userIsolatedCache().containsKey(user)) {
                    Tuple2<Integer, Long> tuple2 = this.userIsolatedCacheCount().get(user);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Integer count = (Integer)tuple2._1();
                    Integer count2 = count;
                    this.userIsolatedCacheCount().put(user, (Tuple2<Integer, Long>)new Tuple2((Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(count2) + 1), (Object)Predef$.MODULE$.long2Long(System.currentTimeMillis())));
                    sparkSession2 = this.userIsolatedCache().get(user);
                } else {
                    this.userIsolatedCacheCount().put(user, (Tuple2<Integer, Long>)new Tuple2((Object)Predef$.MODULE$.int2Integer(1), (Object)Predef$.MODULE$.long2Long(System.currentTimeMillis())));
                    SparkSession newSession = this.newSparkSession(this.spark);
                    this.userIsolatedCache().put(user, newSession);
                    sparkSession2 = newSession;
                }
                sparkSession = sparkSession2;
            }
            return sparkSession;
        }
        throw new MatchError((Object)value);
    }

    private SparkSession newSparkSession(SparkSession rootSparkSession) {
        SparkSession newSparkSession = rootSparkSession.newSession();
        KyuubiSparkUtil$.MODULE$.initializeSparkSession(newSparkSession, this.conf().get(KyuubiConf$.MODULE$.ENGINE_SESSION_SPARK_INITIALIZE_SQL()));
        return newSparkSession;
    }

    @Override
    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        return (Session)conf.get((Object)"kyuubi.session.handle").map((Function1 & Serializable & scala.Serializable)uuid -> SessionHandle$.MODULE$.fromUUID((String)uuid)).flatMap((Function1 & Serializable & scala.Serializable)sessionHandle -> this.getSessionOption((SessionHandle)sessionHandle)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            SparkSession sparkSession;
            try {
                sparkSession = this.getOrNewSparkSession(user);
            }
            catch (Exception e) {
                throw KyuubiSQLException$.MODULE$.apply(e);
            }
            SparkSession sparkSession2 = sparkSession;
            return new SparkSessionImpl(protocol, user, password, ipAddress, conf, this, sparkSession2);
        });
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) {
        BoxedUnit boxedUnit;
        if (!this.userIsolatedSparkSession()) {
            Session session = this.getSession(sessionHandle);
            if (session != null) {
                Object object = this.userIsolatedCacheLock();
                synchronized (object) {
                    Tuple2<Integer, Long> tuple2;
                    if (this.userIsolatedCacheCount().containsKey(session.user())) {
                        Tuple2<Integer, Long> tuple22 = this.userIsolatedCacheCount().get(session.user());
                        if (tuple22 == null) {
                            throw new MatchError(tuple22);
                        }
                        Integer count = (Integer)tuple22._1();
                        Integer count2 = count;
                        tuple2 = this.userIsolatedCacheCount().put(session.user(), (Tuple2<Integer, Long>)new Tuple2((Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(count2) - 1), (Object)Predef$.MODULE$.long2Long(System.currentTimeMillis())));
                    } else {
                        tuple2 = BoxedUnit.UNIT;
                    }
                    Tuple2<Integer, Long> tuple23 = tuple2;
                    // MONITOREXIT @DISABLED, blocks:[0, 17, 19, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var4_3
                    boxedUnit = tuple23;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            try {
                super.closeSession(sessionHandle);
            }
            catch (KyuubiSQLException e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Error closing session ").append(sessionHandle).toString(), e);
            }
        }
        finally {
            if (BoxesRunTime.unboxToBoolean((Object)KyuubiSparkUtil$.MODULE$.getSessionConf(KyuubiConf$.MODULE$.OPERATION_RESULT_SAVE_TO_FILE(), this.spark))) {
                Path sessionSavePath = this.getSessionResultSavePath(sessionHandle);
                try {
                    FileSystem fs = sessionSavePath.getFileSystem(this.spark.sparkContext().hadoopConfiguration());
                    if (fs.exists(sessionSavePath)) {
                        fs.delete(sessionSavePath, true);
                        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Deleted session result path: ").append(sessionSavePath).toString());
                    }
                }
                catch (Throwable e) {
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error cleaning session result path: ").append(sessionSavePath).toString(), e);
                }
            }
        }
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Session stopped due to shared level is Connection.");
            this.stopSession();
            return;
        }
    }

    private void stopSession() {
        SparkSQLEngine$.MODULE$.currentEngine().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public Path getEngineResultSavePath() {
        return new Path(this.conf().get(KyuubiConf$.MODULE$.OPERATION_RESULT_SAVE_TO_FILE_DIR()), KyuubiSparkUtil$.MODULE$.engineId());
    }

    private Path getSessionResultSavePath(SessionHandle sessionHandle) {
        return new Path(this.getEngineResultSavePath(), sessionHandle.identifier().toString());
    }

    public Path getOperationResultSavePath(SessionHandle sessionHandle, OperationHandle opHandle) {
        return new Path(this.getSessionResultSavePath(sessionHandle), opHandle.identifier().toString());
    }

    private SparkSQLSessionManager(String name, SparkSession spark) {
        this.spark = spark;
        super(name);
        this.operationManager = new SparkSQLOperationManager();
        this.userIsolatedCacheLock = new Object();
        this.userIsolatedSparkSessionThread = None$.MODULE$;
    }

    public SparkSQLSessionManager(SparkSession spark) {
        this(SparkSQLSessionManager.class.getSimpleName(), spark);
    }
}

