/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.session;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.jdbc.connection.ConnectionProvider$;
import org.apache.kyuubi.engine.jdbc.util.KyuubiJdbcUtils$;
import org.apache.kyuubi.session.AbstractSession;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\f\u0018\u0001\u0011B\u0011B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u001c\t\u0013a\u0002!\u0011!Q\u0001\ne2\u0005\"C$\u0001\u0005\u0003\u0005\u000b\u0011B\u001dI\u0011%I\u0005A!A!\u0002\u0013I$\nC\u0005L\u0001\t\u0005\t\u0015!\u0003M\u001f\"I\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0016\u0005\u0006+\u0002!\tA\u0016\u0005\b?\u0002\u0011\r\u0011\"\u0011a\u0011\u0019!\u0007\u0001)A\u0005C\"QQ\r\u0001a\u0001\u0002\u0004%\t!\u00074\t\u0015=\u0004\u0001\u0019!a\u0001\n\u0003I\u0002\u000fC\u0005x\u0001\u0001\u0007\t\u0011)Q\u0005O\"I\u0001\u0010\u0001a\u0001\u0002\u0004%I!\u001f\u0005\n{\u0002\u0001\r\u00111A\u0005\nyD!\"!\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003{\u0011%\t\u0019\u0001\u0001b\u0001\n\u0013\t)\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0004\u0011\u001d\t)\u0002\u0001C\u0005\u0003\u000bAq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002\u001c\u0001!\t%!\b\t\u000f\u0005=\u0002\u0001\"\u0011\u0002\u001a\ty!\n\u001a2d'\u0016\u001c8/[8o\u00136\u0004HN\u0003\u0002\u00193\u000591/Z:tS>t'B\u0001\u000e\u001c\u0003\u0011QGMY2\u000b\u0005qi\u0012AB3oO&tWM\u0003\u0002\u001f?\u000511._;vE&T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sO\u000e\u00011C\u0001\u0001&!\t1\u0003&D\u0001(\u0015\tAR$\u0003\u0002*O\ty\u0011IY:ue\u0006\u001cGoU3tg&|g.\u0001\u0005qe>$xnY8m!\taS'D\u0001.\u0015\tqs&\u0001\u0004uQJLg\r\u001e\u0006\u0003aE\n1A\u001d9d\u0015\t\u00114'A\u0004tKJ4\u0018nY3\u000b\u0005Qz\u0012\u0001\u00025jm\u0016L!AN\u0017\u0003!Q\u0003&o\u001c;pG>dg+\u001a:tS>t\u0017B\u0001\u0016)\u0003\u0011)8/\u001a:\u0011\u0005i\u001aeBA\u001eB!\tat(D\u0001>\u0015\tq4%\u0001\u0004=e>|GO\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!iP\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002C\u007f%\u0011\u0001\bK\u0001\ta\u0006\u001c8o^8sI&\u0011q\tK\u0001\nSB\fE\r\u001a:fgNL!!\u0013\u0015\u0002\t\r|gN\u001a\t\u0005u5K\u0014(\u0003\u0002O\u000b\n\u0019Q*\u00199\n\u0005-C\u0013AD:fgNLwN\\'b]\u0006<WM\u001d\t\u0003MIK!aU\u0014\u0003\u001dM+7o]5p]6\u000bg.Y4fe&\u0011\u0001\u000bK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f]K&l\u0017/^=B\u0011\u0001\fA\u0007\u0002/!)!f\u0002a\u0001W!)\u0001h\u0002a\u0001s!)qi\u0002a\u0001s!)\u0011j\u0002a\u0001s!)1j\u0002a\u0001\u0019\")\u0001k\u0002a\u0001#\u00061\u0001.\u00198eY\u0016,\u0012!\u0019\t\u0003M\tL!aY\u0014\u0003\u001bM+7o]5p]\"\u000bg\u000e\u001a7f\u0003\u001dA\u0017M\u001c3mK\u0002\n\u0011c]3tg&|gnQ8o]\u0016\u001cG/[8o+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002Y\u0006!!.\u0019<b\u0013\tq\u0017N\u0001\u0006D_:tWm\u0019;j_:\fQc]3tg&|gnQ8o]\u0016\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0002rkB\u0011!o]\u0007\u0002\u007f%\u0011Ao\u0010\u0002\u0005+:LG\u000fC\u0004w\u0017\u0005\u0005\t\u0019A4\u0002\u0007a$\u0013'\u0001\ntKN\u001c\u0018n\u001c8D_:tWm\u0019;j_:\u0004\u0013\u0001\u00053bi\u0006\u0014\u0017m]3NKR\fG)\u0019;b+\u0005Q\bC\u00015|\u0013\ta\u0018N\u0001\tECR\f'-Y:f\u001b\u0016$\u0018\rR1uC\u0006!B-\u0019;bE\u0006\u001cX-T3uC\u0012\u000bG/Y0%KF$\"!]@\t\u000fYt\u0011\u0011!a\u0001u\u0006\tB-\u0019;bE\u0006\u001cX-T3uC\u0012\u000bG/\u0019\u0011\u0002\u0015-LX/\u001e2j\u0007>tg-\u0006\u0002\u0002\bA!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000eu\taaY8oM&<\u0017\u0002BA\t\u0003\u0017\u0011!bS=vk\nL7i\u001c8g\u0003-Y\u00170^;cS\u000e{gN\u001a\u0011\u0002\u001b9|'/\\1mSj,7i\u001c8g\u0003\u0011y\u0007/\u001a8\u0015\u0003E\fqaZ3u\u0013:4w\u000e\u0006\u0003\u0002 \u0005\u0015\u0002c\u0001\u0017\u0002\"%\u0019\u00111E\u0017\u0003\u001bQ;U\r^%oM>4\u0016\r\\;f\u0011\u001d\t9\u0003\u0006a\u0001\u0003S\t\u0001\"\u001b8g_RK\b/\u001a\t\u0004Y\u0005-\u0012bAA\u0017[\taAkR3u\u0013:4w\u000eV=qK\u0006)1\r\\8tK\u0002")
public class JdbcSessionImpl
extends AbstractSession {
    private final SessionHandle handle = (SessionHandle)super.conf().get((Object)"kyuubi.session.handle").map((Function1 & Serializable & scala.Serializable)uuid -> SessionHandle$.MODULE$.fromUUID(uuid)).getOrElse((Function0 & Serializable & scala.Serializable)() -> SessionHandle$.MODULE$.apply());
    private Connection sessionConnection;
    private DatabaseMetaData databaseMetaData;
    private final KyuubiConf kyuubiConf = this.normalizeConf();

    public SessionHandle handle() {
        return this.handle;
    }

    public Connection sessionConnection() {
        return this.sessionConnection;
    }

    public void sessionConnection_$eq(Connection x$1) {
        this.sessionConnection = x$1;
    }

    private DatabaseMetaData databaseMetaData() {
        return this.databaseMetaData;
    }

    private void databaseMetaData_$eq(DatabaseMetaData x$1) {
        this.databaseMetaData = x$1;
    }

    private KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    private KyuubiConf normalizeConf() {
        BoxedUnit boxedUnit;
        KyuubiConf kyuubiConf = super.sessionManager().getConf().clone();
        if (BoxesRunTime.unboxToBoolean((Object)kyuubiConf.get(KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_PROPAGATECREDENTIAL()))) {
            kyuubiConf.set(KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_USER(), (Object)super.user());
            boxedUnit = kyuubiConf.set(KyuubiConf$.MODULE$.ENGINE_JDBC_CONNECTION_PASSWORD(), (Object)super.password());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        super.conf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return kyuubiConf.set(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        return kyuubiConf;
    }

    public void open() {
        this.info((Function0 & Serializable & scala.Serializable)() -> "Starting to open jdbc session.");
        if (this.sessionConnection() == null) {
            this.sessionConnection_$eq(ConnectionProvider$.MODULE$.create(this.kyuubiConf()));
            this.databaseMetaData_$eq(this.sessionConnection().getMetaData());
        }
        KyuubiJdbcUtils$.MODULE$.initializeJdbcSession(this.kyuubiConf(), this.sessionConnection(), (Seq<String>)((Seq)this.kyuubiConf().get(KyuubiConf$.MODULE$.ENGINE_JDBC_SESSION_INITIALIZE_SQL())));
        super.open();
        this.info((Function0 & Serializable & scala.Serializable)() -> "The jdbc session is started.");
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.assert(this.databaseMetaData() != null, (Function0 & Serializable & scala.Serializable)() -> "JDBC session has not been initialized");
            TGetInfoType tGetInfoType = infoType;
            if (TGetInfoType.CLI_SERVER_NAME.equals(tGetInfoType) ? true : TGetInfoType.CLI_DBMS_NAME.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.databaseMetaData().getDatabaseProductName());
            }
            if (TGetInfoType.CLI_DBMS_VER.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)this.databaseMetaData().getDatabaseProductVersion());
            }
            if (TGetInfoType.CLI_ODBC_KEYWORDS.equals(tGetInfoType)) {
                return TGetInfoValue.stringValue((String)"Unimplemented");
            }
            if (TGetInfoType.CLI_MAX_COLUMN_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxColumnNameLength());
            }
            if (TGetInfoType.CLI_MAX_SCHEMA_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxSchemaNameLength());
            }
            if (TGetInfoType.CLI_MAX_TABLE_NAME_LEN.equals(tGetInfoType)) {
                return TGetInfoValue.lenValue((long)this.databaseMetaData().getMaxTableNameLength());
            }
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        });
    }

    public void close() {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.sessionConnection() != null) {
                this.sessionConnection().close();
                return;
            }
        });
        if (try_ instanceof Success) {
            this.info((Function0 & Serializable & scala.Serializable)() -> "Closed session connection.");
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.warn((Function0 & Serializable & scala.Serializable)() -> "Failed to close session connection, ignored it.", exception);
        } else {
            throw new MatchError((Object)try_);
        }
        super.close();
    }

    public JdbcSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf, SessionManager sessionManager) {
        super(protocol, user, password, ipAddress, conf, sessionManager);
    }
}

