/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;

public final class SingleDoOnSuccess<T>
extends Single<T> {
    final SingleSource<T> source;
    final Consumer<? super T> onSuccess;

    public SingleDoOnSuccess(SingleSource<T> source, Consumer<? super T> onSuccess) {
        this.source = source;
        this.onSuccess = onSuccess;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        this.source.subscribe(new SingleObserver<T>(){

            @Override
            public void onSubscribe(Disposable d) {
                s.onSubscribe(d);
            }

            @Override
            public void onSuccess(T value) {
                try {
                    SingleDoOnSuccess.this.onSuccess.accept(value);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    s.onError(ex);
                    return;
                }
                s.onSuccess(value);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
            }
        });
    }
}

