/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceImpl
implements Resource {
    private List<Capability> allCapabilities;
    private Map<String, List<Capability>> capabilityMap;
    private List<Requirement> allRequirements;
    private Map<String, List<Requirement>> requirementMap;

    ResourceImpl() {
    }

    void setCapabilities(List<Capability> capabilities) {
        this.allCapabilities = capabilities;
        this.capabilityMap = new HashMap<String, List<Capability>>();
        for (Capability capability : capabilities) {
            List<Capability> list = this.capabilityMap.get(capability.getNamespace());
            if (list == null) {
                list = new LinkedList<Capability>();
                this.capabilityMap.put(capability.getNamespace(), list);
            }
            list.add(capability);
        }
    }

    public List<Capability> getCapabilities(String namespace) {
        return namespace == null ? this.allCapabilities : this.capabilityMap.get(namespace);
    }

    void setRequirements(List<Requirement> requirements) {
        this.allRequirements = requirements;
        this.requirementMap = new HashMap<String, List<Requirement>>();
        for (Requirement requirement : requirements) {
            List<Requirement> list = this.requirementMap.get(requirement.getNamespace());
            if (list == null) {
                list = new LinkedList<Requirement>();
                this.requirementMap.put(requirement.getNamespace(), list);
            }
            list.add(requirement);
        }
    }

    public List<Requirement> getRequirements(String namespace) {
        return namespace == null ? this.allRequirements : this.requirementMap.get(namespace);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        List<Capability> identities = this.getCapabilities("osgi.identity");
        if (identities != null && identities.size() == 1) {
            Capability idCap = identities.get(0);
            Object id = idCap.getAttributes().get("osgi.identity");
            Object version = idCap.getAttributes().get("version");
            builder.append(id).append(" ver=").append(version);
        } else {
            builder.append("ResourceImpl [caps=");
            builder.append(this.allCapabilities);
            builder.append(", reqs=");
            builder.append(this.allRequirements);
            builder.append("]");
        }
        return builder.toString();
    }
}

