/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.helper.TargetedPID;

abstract class ConfigurationBase {
    private final ConfigurationManager configurationManager;
    private final PersistenceManager persistenceManager;
    private final TargetedPID baseId;

    protected ConfigurationBase(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String baseId) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("ConfigurationManager must not be null");
        }
        if (persistenceManager == null) {
            throw new IllegalArgumentException("PersistenceManager must not be null");
        }
        this.configurationManager = configurationManager;
        this.persistenceManager = persistenceManager;
        this.baseId = new TargetedPID(baseId);
    }

    ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    TargetedPID getBaseId() {
        return this.baseId;
    }

    boolean isActive() {
        return this.configurationManager.isActive();
    }

    abstract void store() throws IOException;

    void storeSilently() {
        try {
            this.store();
        }
        catch (IOException ioe) {
            this.configurationManager.log(1, "Persisting ID {0} failed", new Object[]{this.getBaseId(), ioe});
        }
    }

    protected static void replaceProperty(Dictionary properties, String key, String value) {
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }
}

