/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.List;
import jline.UnixTerminal;
import jline.internal.TerminalLineSettings;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.Signal;
import org.apache.karaf.shell.api.console.SignalListener;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.ssh.KnownHostsManager;
import org.apache.karaf.shell.ssh.ServerKeyVerifierImpl;
import org.apache.karaf.shell.ssh.SshTerminal;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="ssh", name="ssh", description="Connects to a remote SSH server")
@Service
public class SshAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-l", aliases={"--username"}, description="The user name for remote login", required=false, multiValued=false)
    private String username;
    @Option(name="-P", aliases={"--password"}, description="The password for remote login", required=false, multiValued=false)
    private String password;
    @Option(name="-p", aliases={"--port"}, description="The port to use for SSH connection", required=false, multiValued=false)
    private int port = 22;
    @Option(name="-k", aliases={"--keyfile"}, description="The private keyFile location when using key login, need have BouncyCastle registered as security provider using this flag", required=false, multiValued=false)
    private String keyFile;
    @Option(name="-q", description="Quiet Mode. Do not ask for confirmations", required=false, multiValued=false)
    private boolean quiet;
    @Option(name="-r", aliases={"--retries"}, description="retry connection establishment (up to attempts times)", required=false, multiValued=false)
    private int retries = 0;
    @Argument(index=0, name="hostname", description="The host name to connect to via SSH", required=true, multiValued=false)
    private String hostname;
    @Argument(index=1, name="command", description="Optional command to execute", required=false, multiValued=true)
    private List<String> command;
    @Reference
    private Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        block25: {
            if (this.hostname.indexOf(64) >= 0) {
                if (this.username == null) {
                    this.username = this.hostname.substring(0, this.hostname.indexOf(64));
                }
                this.hostname = this.hostname.substring(this.hostname.indexOf(64) + 1, this.hostname.length());
            }
            System.out.println("Connecting to host " + this.hostname + " on port " + this.port);
            if (this.username == null) {
                this.username = (String)this.session.get("USER");
            }
            if (this.username == null) {
                this.log.debug("Prompting user for login");
                if (this.username == null) {
                    this.username = this.session.readLine("Login: ", null);
                }
            }
            SshClient client = SshClient.setUpDefaultClient();
            this.setupAgent(this.username, this.keyFile, client);
            KnownHostsManager knownHostsManager = new KnownHostsManager(new File(System.getProperty("user.home"), ".sshkaraf/known_hosts"));
            ServerKeyVerifierImpl serverKeyVerifier = new ServerKeyVerifierImpl(knownHostsManager, this.quiet);
            client.setServerKeyVerifier((ServerKeyVerifier)serverKeyVerifier);
            this.log.debug("Created client: {}", (Object)client);
            client.setUserInteraction(new UserInteraction(){

                public void welcome(String banner) {
                    System.out.println(banner);
                }

                public String[] interactive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                    String[] answers = new String[prompt.length];
                    try {
                        for (int i = 0; i < prompt.length; ++i) {
                            answers[i] = SshAction.this.session.readLine(prompt[i] + " ", echo[i] ? null : Character.valueOf('*'));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return answers;
                }
            });
            client.start();
            try {
                ClientSession sshSession = SshAction.connectWithRetries(client, this.username, this.hostname, this.port, this.retries);
                Object oldIgnoreInterrupts = this.session.get("karaf.ignoreInterrupts");
                try {
                    ChannelShell channel;
                    if (this.password != null) {
                        sshSession.addPasswordIdentity(this.password);
                    }
                    sshSession.auth().verify();
                    System.out.println("Connected");
                    this.session.put("karaf.ignoreInterrupts", (Object)Boolean.TRUE);
                    StringBuilder sb = new StringBuilder();
                    if (this.command != null) {
                        for (String cmd : this.command) {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append(cmd);
                        }
                    }
                    if (sb.length() > 0) {
                        channel = sshSession.createChannel("exec", sb.append("\n").toString());
                        channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
                        channel.setOut((OutputStream)new NoCloseOutputStream((OutputStream)System.out));
                        channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)System.err));
                        channel.open().verify();
                        channel.waitFor(2, 0L);
                        break block25;
                    }
                    if (this.session.getTerminal() != null) {
                        channel = sshSession.createShellChannel();
                        final jline.Terminal jlineTerminal = (jline.Terminal)this.session.get(".jline.terminal");
                        if (jlineTerminal instanceof UnixTerminal) {
                            TerminalLineSettings settings = ((UnixTerminal)jlineTerminal).getSettings();
                            HashMap<PtyMode, Integer> modes = new HashMap<PtyMode, Integer>();
                            modes.put(PtyMode.VINTR, settings.getProperty("vintr"));
                            modes.put(PtyMode.VQUIT, settings.getProperty("vquit"));
                            modes.put(PtyMode.VERASE, settings.getProperty("verase"));
                            modes.put(PtyMode.VKILL, settings.getProperty("vkill"));
                            modes.put(PtyMode.VEOF, settings.getProperty("veof"));
                            modes.put(PtyMode.VEOL, settings.getProperty("veol"));
                            modes.put(PtyMode.VEOL2, settings.getProperty("veol2"));
                            modes.put(PtyMode.VSTART, settings.getProperty("vstart"));
                            modes.put(PtyMode.VSTOP, settings.getProperty("vstop"));
                            modes.put(PtyMode.VSUSP, settings.getProperty("vsusp"));
                            modes.put(PtyMode.VDSUSP, settings.getProperty("vdusp"));
                            modes.put(PtyMode.VREPRINT, settings.getProperty("vreprint"));
                            modes.put(PtyMode.VWERASE, settings.getProperty("vwerase"));
                            modes.put(PtyMode.VLNEXT, settings.getProperty("vlnext"));
                            modes.put(PtyMode.VSTATUS, settings.getProperty("vstatus"));
                            modes.put(PtyMode.VDISCARD, settings.getProperty("vdiscard"));
                            modes.put(PtyMode.IGNPAR, this.getFlag(settings, PtyMode.IGNPAR));
                            modes.put(PtyMode.PARMRK, this.getFlag(settings, PtyMode.PARMRK));
                            modes.put(PtyMode.INPCK, this.getFlag(settings, PtyMode.INPCK));
                            modes.put(PtyMode.ISTRIP, this.getFlag(settings, PtyMode.ISTRIP));
                            modes.put(PtyMode.INLCR, this.getFlag(settings, PtyMode.INLCR));
                            modes.put(PtyMode.IGNCR, this.getFlag(settings, PtyMode.IGNCR));
                            modes.put(PtyMode.ICRNL, this.getFlag(settings, PtyMode.ICRNL));
                            modes.put(PtyMode.IXON, this.getFlag(settings, PtyMode.IXON));
                            modes.put(PtyMode.IXANY, this.getFlag(settings, PtyMode.IXANY));
                            modes.put(PtyMode.IXOFF, this.getFlag(settings, PtyMode.IXOFF));
                            modes.put(PtyMode.ISIG, this.getFlag(settings, PtyMode.ISIG));
                            modes.put(PtyMode.ICANON, this.getFlag(settings, PtyMode.ICANON));
                            modes.put(PtyMode.ECHO, this.getFlag(settings, PtyMode.ECHO));
                            modes.put(PtyMode.ECHOE, this.getFlag(settings, PtyMode.ECHOE));
                            modes.put(PtyMode.ECHOK, this.getFlag(settings, PtyMode.ECHOK));
                            modes.put(PtyMode.ECHONL, this.getFlag(settings, PtyMode.ECHONL));
                            modes.put(PtyMode.NOFLSH, this.getFlag(settings, PtyMode.NOFLSH));
                            modes.put(PtyMode.TOSTOP, this.getFlag(settings, PtyMode.TOSTOP));
                            modes.put(PtyMode.IEXTEN, this.getFlag(settings, PtyMode.IEXTEN));
                            modes.put(PtyMode.OPOST, this.getFlag(settings, PtyMode.OPOST));
                            modes.put(PtyMode.OLCUC, this.getFlag(settings, PtyMode.OLCUC));
                            modes.put(PtyMode.ONLCR, this.getFlag(settings, PtyMode.ONLCR));
                            modes.put(PtyMode.OCRNL, this.getFlag(settings, PtyMode.OCRNL));
                            modes.put(PtyMode.ONOCR, this.getFlag(settings, PtyMode.ONOCR));
                            modes.put(PtyMode.ONLRET, this.getFlag(settings, PtyMode.ONLRET));
                            channel.setPtyModes(modes);
                        } else if (this.session.getTerminal() instanceof SshTerminal) {
                            channel.setPtyModes(((SshTerminal)this.session.getTerminal()).getEnvironment().getPtyModes());
                        } else {
                            channel.setupSensibleDefaultPty();
                        }
                        channel.setPtyColumns(this.getTermWidth());
                        channel.setPtyLines(this.getTermHeight());
                        channel.setAgentForwarding(true);
                        channel.setEnv("TERM", this.session.getTerminal().getType());
                        Object ctype = this.session.get("LC_CTYPE");
                        if (ctype != null) {
                            channel.setEnv("LC_CTYPE", ctype.toString());
                        }
                        channel.setIn((InputStream)new NoCloseInputStream(System.in));
                        channel.setOut((OutputStream)new NoCloseOutputStream((OutputStream)System.out));
                        channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)System.err));
                        channel.open().verify();
                        SignalListener signalListener = new SignalListener(){

                            public void signal(Signal signal) {
                                try {
                                    try {
                                        Field field = jlineTerminal.getClass().getSuperclass().getDeclaredField("settings");
                                        field.setAccessible(true);
                                        Object settings = field.get(jlineTerminal);
                                        field = settings.getClass().getDeclaredField("configLastFetched");
                                        field.setAccessible(true);
                                        field.setLong(settings, 0L);
                                    }
                                    catch (Throwable field) {
                                        // empty catch block
                                    }
                                    org.apache.sshd.common.Session sshSession = channel.getSession();
                                    Buffer buffer = sshSession.createBuffer((byte)98);
                                    buffer.putInt((long)channel.getRecipient());
                                    buffer.putString("window-change");
                                    buffer.putBoolean(false);
                                    buffer.putInt((long)SshAction.this.session.getTerminal().getWidth());
                                    buffer.putInt((long)SshAction.this.session.getTerminal().getHeight());
                                    buffer.putInt(0L);
                                    buffer.putInt(0L);
                                    sshSession.writePacket(buffer);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        };
                        this.session.getTerminal().addSignalListener(signalListener, new Signal[]{Signal.WINCH});
                        try {
                            channel.waitFor(2, 0L);
                            break block25;
                        }
                        finally {
                            this.session.getTerminal().removeSignalListener(signalListener);
                        }
                    }
                    throw new IllegalStateException("No terminal for interactive ssh session");
                }
                finally {
                    this.session.put("karaf.ignoreInterrupts", oldIgnoreInterrupts);
                    sshSession.close(false);
                }
            }
            finally {
                client.stop();
            }
        }
        return null;
    }

    private int getFlag(TerminalLineSettings settings, PtyMode mode) {
        String name = mode.toString().toLowerCase();
        return settings.getPropertyAsString(name) != null ? 1 : 0;
    }

    private int getTermWidth() {
        Terminal term = this.session.getTerminal();
        return term != null ? term.getWidth() : 80;
    }

    private int getTermHeight() {
        Terminal term = this.session.getTerminal();
        return term != null ? term.getHeight() : 25;
    }

    private void setupAgent(String user, String keyFile, SshClient client) {
        URL url = this.getClass().getClassLoader().getResource("karaf.key");
        SshAgent agent = this.startAgent(user, url, keyFile);
        client.setAgentFactory((SshAgentFactory)new LocalAgentFactory(agent));
        client.getProperties().put("SSH_AUTH_SOCK", "local");
    }

    private SshAgent startAgent(String user, URL privateKeyUrl, String keyFile) {
        InputStream is = null;
        try {
            AgentImpl agent = new AgentImpl();
            is = privateKeyUrl.openStream();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            is.close();
            agent.addIdentity(keyPair, user);
            if (keyFile != null) {
                String[] keyFiles = new String[]{keyFile};
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(keyFiles);
                for (KeyPair key : fileKeyPairProvider.loadKeys()) {
                    agent.addIdentity(key, user);
                }
            }
            return agent;
        }
        catch (Throwable e) {
            this.close(is);
            System.err.println("Error starting ssh agent for: " + e.getMessage());
            return null;
        }
    }

    private static ClientSession connectWithRetries(SshClient client, String username, String host, int port, int maxAttempts) throws Exception, InterruptedException {
        ClientSession session = null;
        int retries = 0;
        do {
            ConnectFuture future = client.connect(username, host, port);
            future.await();
            try {
                session = future.getSession();
            }
            catch (Exception ex) {
                if (retries++ < maxAttempts) {
                    Thread.sleep(2000L);
                    System.out.println("retrying (attempt " + retries + ") ...");
                    continue;
                }
                throw ex;
            }
        } while (session == null);
        return session;
    }

    private void close(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

