/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import java.util.EventListener;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.handler.ListenerHandler;
import org.apache.felix.http.base.internal.runtime.ListenerInfo;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;

public final class WhiteboardListenerHandler
extends ListenerHandler {
    private final BundleContext bundleContext;

    public WhiteboardListenerHandler(long contextServiceId, ExtServletContext context, ListenerInfo listenerInfo, BundleContext bundleContext) {
        super(contextServiceId, context, listenerInfo);
        this.bundleContext = bundleContext;
    }

    @Override
    public int init() {
        if (this.useCount > 0) {
            ++this.useCount;
            return -1;
        }
        ServiceReference serviceReference = this.getListenerInfo().getServiceReference();
        ServiceObjects so = this.bundleContext.getServiceObjects(serviceReference);
        this.setListener(so == null ? null : (EventListener)so.getService());
        int reason = super.init();
        if (reason != -1) {
            if (so != null) {
                so.ungetService((Object)this.getListener());
            }
            this.setListener(null);
        }
        return reason;
    }

    @Override
    public boolean destroy() {
        EventListener s = this.getListener();
        if (s != null && super.destroy()) {
            ServiceObjects so = this.bundleContext.getServiceObjects(this.getListenerInfo().getServiceReference());
            if (so != null) {
                so.ungetService((Object)s);
            }
            return true;
        }
        return false;
    }
}

