/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.MultiException;
import org.osgi.framework.Bundle;

public abstract class BundlesCommandWithConfirmation
extends BundlesCommand {
    @Option(name="--force", aliases={"-f"}, description="Forces the command to execute", required=false, multiValued=false)
    boolean force;
    protected String errorMessage = "Unable to execute command on bundle ";

    public BundlesCommandWithConfirmation() {
        super(false);
    }

    @Override
    protected Object doExecute() throws Exception {
        this.doExecute(this.force);
        return null;
    }

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        if (bundles.isEmpty()) {
            System.err.println("No bundles specified.");
            return;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Bundle bundle : bundles) {
            try {
                this.executeOnBundle(bundle);
            }
            catch (Exception e) {
                exceptions.add(new Exception(this.errorMessage + bundle.getBundleId() + ": " + e.getMessage(), e));
            }
        }
        MultiException.throwIf((String)"Error executing command on bundles", exceptions);
    }

    protected abstract void executeOnBundle(Bundle var1) throws Exception;
}

