/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.karaf.config.command.ConfigCommandSupport;
import org.apache.karaf.shell.commands.Option;

public abstract class ConfigPropertyCommandSupport
extends ConfigCommandSupport {
    @Option(name="-p", aliases={"--pid"}, description="The configuration pid", required=false, multiValued=false)
    protected String pid;

    protected Object doExecute() throws Exception {
        Dictionary props = this.getEditedProps();
        if (props == null && this.pid == null) {
            System.err.println("No configuration is being edited--run the edit command first");
        } else {
            if (props == null) {
                props = new Properties();
            }
            this.propertyAction(props);
            if (this.requiresUpdate(this.pid)) {
                this.configRepository.update(this.pid, props);
            }
        }
        return null;
    }

    protected abstract void propertyAction(Dictionary var1);

    protected boolean requiresUpdate(String pid) {
        return pid != null;
    }

    @Override
    protected Dictionary getEditedProps() throws Exception {
        Dictionary props = this.configRepository.getConfigProperties(this.pid);
        return props != null ? props : super.getEditedProps();
    }
}

