/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.metadata.authorizer.StandardAcl;

public final class StandardAclWithId {
    private final Uuid id;
    private final StandardAcl acl;

    public static StandardAclWithId fromRecord(AccessControlEntryRecord record) {
        return new StandardAclWithId(record.id(), StandardAcl.fromRecord(record));
    }

    public StandardAclWithId(Uuid id, StandardAcl acl) {
        this.id = id;
        this.acl = acl;
    }

    public Uuid id() {
        return this.id;
    }

    public StandardAcl acl() {
        return this.acl;
    }

    public AccessControlEntryRecord toRecord() {
        return new AccessControlEntryRecord().setId(this.id).setResourceType(this.acl.resourceType().code()).setResourceName(this.acl.resourceName()).setPatternType(this.acl.patternType().code()).setPrincipal(this.acl.principal()).setHost(this.acl.host()).setOperation(this.acl.operation().code()).setPermissionType(this.acl.permissionType().code());
    }

    public AclBinding toBinding() {
        return this.acl.toBinding();
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(StandardAclWithId.class)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        StandardAclWithId other = (StandardAclWithId)o;
        return this.id.equals((Object)other.id) && this.acl.equals(other.acl);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.acl);
    }

    public String toString() {
        return "StandardAclWithId(id=" + this.id + ", acl=" + this.acl + ")";
    }
}

