/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.PrintWriter;
import java.util.List;
import java.util.Optional;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.command.CommandUtils;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.glob.GlobVisitor;
import org.apache.kafka.shell.state.MetadataShellState;
import org.jline.reader.Candidate;

public final class CdCommandHandler
implements Commands.Handler {
    public static final Commands.Type TYPE = new CdCommandType();
    private final Optional<String> target;

    public CdCommandHandler(Optional<String> target) {
        this.target = target;
    }

    @Override
    public void run(Optional<InteractiveShell> shell, PrintWriter writer, MetadataShellState state) throws Exception {
        String effectiveTarget = this.target.orElse("/");
        new GlobVisitor(effectiveTarget, entryOption -> {
            if (entryOption.isPresent()) {
                if (!((GlobVisitor.MetadataNodeInfo)entryOption.get()).node().isDirectory()) {
                    writer.println("cd: " + effectiveTarget + ": not a directory.");
                } else {
                    state.setWorkingDirectory(((GlobVisitor.MetadataNodeInfo)entryOption.get()).absolutePath());
                }
            } else {
                writer.println("cd: " + effectiveTarget + ": no such directory.");
            }
        }).accept(state);
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof CdCommandHandler)) {
            return false;
        }
        CdCommandHandler o = (CdCommandHandler)other;
        return o.target.equals(this.target);
    }

    public static class CdCommandType
    implements Commands.Type {
        private CdCommandType() {
        }

        @Override
        public String name() {
            return "cd";
        }

        @Override
        public String description() {
            return "Set the current working directory.";
        }

        @Override
        public boolean shellOnly() {
            return true;
        }

        @Override
        public void addArguments(ArgumentParser parser) {
            parser.addArgument(new String[]{"target"}).nargs("?").help("The directory to change to.");
        }

        @Override
        public Commands.Handler createHandler(Namespace namespace) {
            return new CdCommandHandler(Optional.ofNullable(namespace.getString("target")));
        }

        @Override
        public void completeNext(MetadataShellState state, List<String> nextWords, List<Candidate> candidates) throws Exception {
            if (nextWords.size() == 1) {
                CommandUtils.completePath(state, nextWords.get(0), candidates);
            }
        }
    }
}

