/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.snapshot;

import java.util.function.Consumer;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.UnalignedMemoryRecords;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.snapshot.RawSnapshotWriter;

public final class NotifyingRawSnapshotWriter
implements RawSnapshotWriter {
    private final RawSnapshotWriter writer;
    private final Consumer<OffsetAndEpoch> callback;

    public NotifyingRawSnapshotWriter(RawSnapshotWriter writer, Consumer<OffsetAndEpoch> callback) {
        this.writer = writer;
        this.callback = callback;
    }

    @Override
    public OffsetAndEpoch snapshotId() {
        return this.writer.snapshotId();
    }

    @Override
    public long sizeInBytes() {
        return this.writer.sizeInBytes();
    }

    @Override
    public void append(UnalignedMemoryRecords records) {
        this.writer.append(records);
    }

    @Override
    public void append(MemoryRecords records) {
        this.writer.append(records);
    }

    @Override
    public boolean isFrozen() {
        return this.writer.isFrozen();
    }

    @Override
    public void freeze() {
        this.writer.freeze();
        this.callback.accept(this.writer.snapshotId());
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public String toString() {
        return this.writer.toString();
    }
}

