/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.migration;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.backends.cassandra.migration.CassandraSchemaTransitions;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.backends.cassandra.migration.MigrationException;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionDAO;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaTransition;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class MigrationTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationTask.class);
    public static final TaskType CASSANDRA_MIGRATION = TaskType.of((String)"cassandra-migration");
    private final CassandraSchemaVersionDAO schemaVersionDAO;
    private final CassandraSchemaTransitions transitions;
    private final SchemaVersion target;

    @VisibleForTesting
    public MigrationTask(CassandraSchemaVersionDAO schemaVersionDAO, CassandraSchemaTransitions transitions, SchemaVersion target) {
        this.schemaVersionDAO = schemaVersionDAO;
        this.transitions = transitions;
        this.target = target;
    }

    public Task.Result run() {
        this.getCurrentVersion().listTransitionsForTarget(this.target).stream().map(this::migration).forEach(Throwing.consumer(this::runMigration).sneakyThrow());
        return Task.Result.COMPLETED;
    }

    private SchemaVersion getCurrentVersion() {
        return ((Optional)this.schemaVersionDAO.getCurrentSchemaVersion().block()).orElse(CassandraSchemaVersionManager.DEFAULT_VERSION);
    }

    private Tuple2<SchemaTransition, Migration> migration(SchemaTransition transition) {
        return Tuples.of((Object)transition, (Object)this.transitions.findMigration(transition).orElseThrow(() -> new MigrationException("unable to find a required Migration for transition " + String.valueOf(transition))));
    }

    private void runMigration(Tuple2<SchemaTransition, Migration> tuple) throws InterruptedException {
        SchemaTransition transition;
        SchemaVersion targetVersion;
        SchemaVersion currentVersion = this.getCurrentVersion();
        if (currentVersion.isAfterOrEquals(targetVersion = (transition = (SchemaTransition)tuple.getT1()).to())) {
            return;
        }
        LOGGER.info("Migrating to version {} ", (Object)transition.toAsString());
        Migration migration = (Migration)tuple.getT2();
        migration.asTask().run().onComplete(new Task.Operation[]{() -> this.schemaVersionDAO.updateVersion(transition.to()).block(), () -> LOGGER.info("Migrating to version {} done", (Object)transition.toAsString())}).onFailure(new Task.Operation[]{() -> LOGGER.warn(this.failureMessage(transition.to())), () -> this.throwMigrationException(transition.to())});
    }

    private void throwMigrationException(SchemaVersion newVersion) {
        throw new MigrationException(this.failureMessage(newVersion));
    }

    private String failureMessage(SchemaVersion newVersion) {
        return String.format("Migrating to version %d partially done. Please check logs for cause of failure and re-run this migration.", newVersion.getValue());
    }

    SchemaVersion getTarget() {
        return this.target;
    }

    public TaskType type() {
        return CASSANDRA_MIGRATION;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.target, Clock.systemUTC().instant()));
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final SchemaVersion toVersion;
        private final Instant timestamp;

        public AdditionalInformation(SchemaVersion toVersion, Instant timestamp) {
            this.toVersion = toVersion;
            this.timestamp = timestamp;
        }

        public int getToVersion() {
            return this.toVersion.getValue();
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class Impl
    implements Factory {
        private final CassandraSchemaVersionDAO schemaVersionDAO;
        private final CassandraSchemaTransitions transitions;

        @Inject
        private Impl(CassandraSchemaVersionDAO schemaVersionDAO, CassandraSchemaTransitions transitions) {
            this.schemaVersionDAO = schemaVersionDAO;
            this.transitions = transitions;
        }

        @Override
        public MigrationTask create(SchemaVersion target) {
            return new MigrationTask(this.schemaVersionDAO, this.transitions, target);
        }
    }

    public static interface Factory {
        public MigrationTask create(SchemaVersion var1);
    }
}

