/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.List;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class FunctionCall
implements FrontendMessage {
    private static final int NULL = -1;
    private final List<Format> argumentFormats;
    private final List<ByteBuf> arguments;
    private final int functionId;
    private final Format resultFormat;

    public FunctionCall(List<Format> argumentFormats, List<ByteBuf> arguments, int functionId, Format resultFormat) {
        this.argumentFormats = Assert.requireNonNull(argumentFormats, "argumentFormats must not be null");
        this.arguments = Assert.requireNonNull(arguments, "arguments must not be null");
        this.functionId = functionId;
        this.resultFormat = Assert.requireNonNull(resultFormat, "resultFormat must not be null");
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer();
            FrontendMessageUtils.writeByte(out, 70);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeInt(out, this.functionId);
            FrontendMessageUtils.writeShort(out, this.argumentFormats.size());
            this.argumentFormats.forEach(format -> FrontendMessageUtils.writeShort(out, (int)format.getDiscriminator()));
            FrontendMessageUtils.writeShort(out, this.arguments.size());
            this.arguments.forEach(argument -> {
                if (argument == null) {
                    FrontendMessageUtils.writeInt(out, -1);
                } else {
                    FrontendMessageUtils.writeInt(out, argument.readableBytes());
                    FrontendMessageUtils.writeBytes(out, argument);
                }
            });
            FrontendMessageUtils.writeShort(out, (int)this.resultFormat.getDiscriminator());
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionCall that = (FunctionCall)o;
        return this.functionId == that.functionId && Objects.equals(this.argumentFormats, that.argumentFormats) && Objects.equals(this.arguments, that.arguments) && this.resultFormat == that.resultFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.argumentFormats, this.arguments, this.functionId, this.resultFormat});
    }

    public String toString() {
        return "FunctionCall{argumentFormats=" + this.argumentFormats + ", arguments=" + this.arguments + ", functionId=" + this.functionId + ", resultFormat=" + (Object)((Object)this.resultFormat) + '}';
    }
}

