/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.ArrayCodec;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.codec.StringCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;

final class StringArrayCodec
extends ArrayCodec<String> {
    StringArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, PostgresqlObjectId.TEXT_ARRAY, new StringCodec(byteBufAllocator), String.class);
    }

    @Override
    public boolean canDecode(int dataType, Format format, Class<?> type) {
        return PostgresqlObjectId.isValid(dataType) && this.doCanDecode(PostgresqlObjectId.valueOf(dataType), format);
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(format, "format must not be null");
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.BPCHAR_ARRAY == type || PostgresqlObjectId.CHAR_ARRAY == type || PostgresqlObjectId.TEXT_ARRAY == type || PostgresqlObjectId.VARCHAR_ARRAY == type | PostgresqlObjectId.NAME_ARRAY == type;
    }
}

