/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class ConnectionContext {
    private static final Logger LOGGER = Loggers.getLogger((String)(ConnectionContext.class.getName() + ".context"));
    private static final boolean CONTEXT_ENABLED = LOGGER.isDebugEnabled();
    private static final boolean CHANNEL_ID_ENABLED = LOGGER.isTraceEnabled();
    private static final AtomicLong CONN_ID = new AtomicLong();
    @Nullable
    private final Integer processId;
    @Nullable
    private final String channelId;
    private final String connectionCounter;
    private final String connectionIdPrefix;

    public ConnectionContext() {
        this.processId = null;
        this.connectionCounter = this.incrementConnectionCounter();
        this.connectionIdPrefix = this.getConnectionIdPrefix();
        this.channelId = null;
    }

    private ConnectionContext(@Nullable Integer processId, @Nullable String channelId, String connectionCounter) {
        this.processId = processId;
        this.channelId = channelId;
        this.connectionCounter = connectionCounter;
        this.connectionIdPrefix = this.getConnectionIdPrefix();
    }

    private String incrementConnectionCounter() {
        return Long.toHexString(CONN_ID.incrementAndGet());
    }

    private String getConnectionIdPrefix() {
        String prefix = String.format("[cid: 0x%s]", this.connectionCounter);
        if (this.processId != null) {
            prefix = prefix + String.format("[pid: %d]", this.processId);
        }
        if (CHANNEL_ID_ENABLED && this.channelId != null) {
            prefix = prefix + String.format("%s", this.channelId);
        }
        return prefix + " ";
    }

    public String getMessage(String original) {
        if (CONTEXT_ENABLED) {
            return this.connectionIdPrefix + original;
        }
        return original;
    }

    public ConnectionContext withChannelId(String channelId) {
        return new ConnectionContext(this.processId, channelId, this.connectionCounter);
    }

    public ConnectionContext withProcessId(int processId) {
        return new ConnectionContext(processId, this.channelId, this.connectionCounter);
    }
}

